/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.api;

import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IClientUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.manager.PluginManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ListNode
implements IDataNode {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private List<IDataNode> nodes;

    public ListNode() {
    }

    public ListNode(IClientUtils utils, RegistryFriendlyByteBuf buf) {
        int count = buf.readInt();
        if (count == 0) {
            this.nodes = Collections.emptyList();
        } else if (count == 1) {
            this.nodes = Collections.singletonList(utils.getDataNodeFactory(buf.readResourceLocation()).create(utils, buf));
        } else {
            this.nodes = new ArrayList<IDataNode>(count);
            for (int i = 0; i < count; ++i) {
                this.nodes.add((IDataNode)utils.getDataNodeFactory(buf.readResourceLocation()).create(utils, buf));
            }
            Collections.sort(this.nodes);
            this.nodes = Collections.unmodifiableList(this.nodes);
        }
    }

    public List<IDataNode> nodes() {
        return Objects.requireNonNullElse(this.nodes, Collections.emptyList());
    }

    public void addChildren(IDataNode node) {
        if (this.nodes == null) {
            this.nodes = new ArrayList<IDataNode>();
        }
        this.nodes.add(node);
    }

    public void optimizeList() {
        if (this.nodes == null || this.nodes.isEmpty()) {
            return;
        }
        for (IDataNode node2 : this.nodes) {
            if (!(node2 instanceof ListNode)) continue;
            ListNode listNode = (ListNode)node2;
            listNode.optimizeList();
        }
        this.nodes.removeIf(node -> {
            if (node instanceof ListNode) {
                ListNode listNode = (ListNode)node;
                return listNode.nodes().isEmpty();
            }
            return false;
        });
        if (this.nodes.isEmpty()) {
            this.nodes = null;
        }
    }

    public abstract void encodeNode(IServerUtils var1, RegistryFriendlyByteBuf var2);

    @Override
    public final void encode(IServerUtils utils, RegistryFriendlyByteBuf buf) {
        List<IDataNode> nodes = this.nodes();
        int countIndex = buf.writerIndex();
        int successfulNodes = 0;
        buf.writeInt(nodes.size());
        for (IDataNode node : nodes) {
            int startOfNode = buf.writerIndex();
            try {
                buf.writeResourceLocation(node.getId());
                node.encode(utils, buf);
                ++successfulNodes;
            }
            catch (Throwable e) {
                buf.writerIndex(startOfNode);
                LOGGER.warn("Failed to write node in {}", (Object)PluginManager.SERVER_REGISTRY.getCurrentLootTable(), (Object)e);
            }
        }
        if (successfulNodes != nodes.size()) {
            int endIndex = buf.writerIndex();
            buf.writerIndex(countIndex);
            buf.writeInt(successfulNodes);
            buf.writerIndex(endIndex);
        }
        this.encodeNode(utils, buf);
    }
}

