/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.fluid;

import com.benbenlaw.core.fluid.FluidRegistryObject;
import com.benbenlaw.core.util.RenderUtil;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class FluidDeferredRegister {
    private static final ResourceLocation OVERLAY = ResourceLocation.withDefaultNamespace((String)"block/water_overlay");
    private static final ResourceLocation RENDER_OVERLAY = ResourceLocation.withDefaultNamespace((String)"textures/misc/underwater.png");
    private static final ResourceLocation LIQUID = ResourceLocation.fromNamespaceAndPath((String)"bblcore", (String)"block/liquid");
    private static final ResourceLocation LIQUID_FLOW = ResourceLocation.fromNamespaceAndPath((String)"bblcore", (String)"block/liquid_flow");
    private static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        @NotNull
        public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
            BlockPos pos;
            ServerLevel world = source.level();
            DispensibleContainerItem bucket = (DispensibleContainerItem)stack.getItem();
            if (bucket.emptyContents(null, (Level)world, pos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING)), null, stack)) {
                bucket.checkExtraContent(null, (Level)world, stack, pos);
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            return super.execute(source, stack);
        }
    };
    private final DeferredRegister<FluidType> fluidTypeRegister;
    private final DeferredRegister<Fluid> fluidRegister;
    private final DeferredRegister<Block> blockRegister;
    private final DeferredRegister<Item> itemRegister;
    static MapColor[] NONE = List.of(MapColor.NONE).toArray(new MapColor[0]);

    public static FluidType.Properties getBaseBuilder() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY);
    }

    public FluidDeferredRegister(String modid) {
        this.blockRegister = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)modid);
        this.fluidRegister = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)modid);
        this.fluidTypeRegister = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)modid);
        this.itemRegister = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)modid);
    }

    public FluidRegistryObject<CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, UnaryOperator.identity(), renderProperties);
    }

    public FluidRegistryObject<CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem> register(String name, UnaryOperator<FluidType.Properties> properties, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, BucketItem::new, properties, renderProperties);
    }

    public <BUCKET extends BucketItem> FluidRegistryObject<CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, BucketCreator<BUCKET> bucketCreator, UnaryOperator<FluidType.Properties> fluidProperties, UnaryOperator<FluidTypeRenderProperties> renderProperties) {
        return this.register(name, (FluidType.Properties)fluidProperties.apply(FluidDeferredRegister.getBaseBuilder()), (FluidTypeRenderProperties)renderProperties.apply(FluidTypeRenderProperties.builder()), bucketCreator, CoreFluidTypes::new);
    }

    public <BUCKET extends BucketItem> FluidRegistryObject<CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BUCKET> register(String name, FluidType.Properties properties, FluidTypeRenderProperties renderProperties, BucketCreator<BUCKET> bucketCreator, BiFunction<FluidType.Properties, FluidTypeRenderProperties, CoreFluidTypes> fluidTypeCreator) {
        DeferredHolder fluidType = this.fluidTypeRegister.register(name, rl -> {
            properties.descriptionId(Util.makeDescriptionId((String)"block", (ResourceLocation)rl));
            return (CoreFluidTypes)((Object)((Object)fluidTypeCreator.apply(properties, renderProperties)));
        });
        ResourceLocation baseKey = ResourceLocation.fromNamespaceAndPath((String)this.fluidRegister.getNamespace(), (String)name);
        BaseFlowingFluid.Properties fluidProperties = new BaseFlowingFluid.Properties((Supplier)fluidType, (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)baseKey), (Supplier)DeferredHolder.create((ResourceKey)Registries.FLUID, (ResourceLocation)baseKey.withPrefix("flowing_"))).bucket((Supplier)DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)baseKey.withSuffix("_bucket"))).block((Supplier)DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)baseKey));
        DeferredHolder stillFluid = this.fluidRegister.register(name, () -> new BaseFlowingFluid.Source(fluidProperties));
        DeferredHolder flowingFluid = this.fluidRegister.register("flowing_" + name, () -> new BaseFlowingFluid.Flowing(fluidProperties));
        DeferredHolder bucket = this.itemRegister.register(name + "_bucket", () -> bucketCreator.create((Fluid)stillFluid.get(), new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
        MapColor color = FluidDeferredRegister.getClosestColor(renderProperties.color);
        DeferredHolder block = this.blockRegister.register(name, () -> new LiquidBlock((FlowingFluid)stillFluid.get(), BlockBehaviour.Properties.of().noCollission().strength(100.0f).noLootTable().replaceable().pushReaction(PushReaction.DESTROY).liquid().mapColor(color)));
        return new FluidRegistryObject(fluidType, stillFluid, flowingFluid, bucket, block);
    }

    private static MapColor getClosestColor(int tint) {
        if (tint == -1) {
            return MapColor.NONE;
        }
        int red = FastColor.ARGB32.red((int)tint);
        int green = FastColor.ARGB32.green((int)tint);
        int blue = FastColor.ARGB32.blue((int)tint);
        MapColor color = MapColor.NONE;
        double minDistance = Double.MAX_VALUE;
        for (MapColor toTest : NONE) {
            int testBlue;
            int testGreen;
            int testRed;
            double distanceSquare;
            if (toTest == null || toTest == MapColor.NONE || !((distanceSquare = FluidDeferredRegister.perceptualColorDistanceSquared(red, green, blue, testRed = FastColor.ARGB32.red((int)toTest.col), testGreen = FastColor.ARGB32.green((int)toTest.col), testBlue = FastColor.ARGB32.blue((int)toTest.col))) < minDistance)) continue;
            minDistance = distanceSquare;
            color = toTest;
        }
        return color;
    }

    private static double perceptualColorDistanceSquared(int red1, int green1, int blue1, int red2, int green2, int blue2) {
        int redMean = red1 + red2 >> 1;
        int r = red1 - red2;
        int g = green1 - green2;
        int b = blue1 - blue2;
        return ((512 + redMean) * r * r >> 8) + 4 * g * g + ((767 - redMean) * b * b >> 8);
    }

    public void register(IEventBus bus) {
        this.blockRegister.register(bus);
        this.fluidRegister.register(bus);
        this.fluidTypeRegister.register(bus);
        this.itemRegister.register(bus);
    }

    public Collection<DeferredHolder<FluidType, ? extends FluidType>> getFluidTypeEntries() {
        return this.fluidTypeRegister.getEntries();
    }

    public Collection<DeferredHolder<Fluid, ? extends Fluid>> getFluidEntries() {
        return this.fluidRegister.getEntries();
    }

    public Collection<DeferredHolder<Block, ? extends Block>> getBlockEntries() {
        return this.blockRegister.getEntries();
    }

    public Collection<DeferredHolder<Item, ? extends Item>> getBucketEntries() {
        return this.itemRegister.getEntries();
    }

    public void registerBucketDispenserBehavior() {
        for (Holder holder : this.getBucketEntries()) {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)holder.value()), (DispenseItemBehavior)BUCKET_DISPENSE_BEHAVIOR);
        }
    }

    @FunctionalInterface
    public static interface BucketCreator<BUCKET extends BucketItem> {
        public BUCKET create(Fluid var1, Item.Properties var2);
    }

    public static class FluidTypeRenderProperties {
        private ResourceLocation stillTexture = LIQUID;
        private ResourceLocation flowingTexture = LIQUID_FLOW;
        private ResourceLocation overlayTexture = OVERLAY;
        private ResourceLocation renderOverlayTexture = RENDER_OVERLAY;
        private int color;

        private FluidTypeRenderProperties() {
        }

        public static FluidTypeRenderProperties builder() {
            return new FluidTypeRenderProperties();
        }

        public FluidTypeRenderProperties texture(ResourceLocation still, ResourceLocation flowing) {
            this.stillTexture = still;
            this.flowingTexture = flowing;
            return this;
        }

        public FluidTypeRenderProperties texture(ResourceLocation still, ResourceLocation flowing, ResourceLocation overlay) {
            this.stillTexture = still;
            this.flowingTexture = flowing;
            this.overlayTexture = overlay;
            return this;
        }

        public FluidTypeRenderProperties renderOverlay(ResourceLocation renderOverlay) {
            this.renderOverlayTexture = renderOverlay;
            return this;
        }

        public FluidTypeRenderProperties tint(int color) {
            this.color = color;
            return this;
        }
    }

    public static class CoreFluidTypes
    extends FluidType {
        public final ResourceLocation stillTexture;
        public final ResourceLocation flowingTexture;
        public final ResourceLocation overlayTexture;
        public final ResourceLocation renderOverlayTexture;
        public final int color;

        public CoreFluidTypes(FluidType.Properties properties, FluidTypeRenderProperties renderProperties) {
            super(properties);
            this.stillTexture = renderProperties.stillTexture;
            this.flowingTexture = renderProperties.flowingTexture;
            this.overlayTexture = renderProperties.overlayTexture;
            this.renderOverlayTexture = renderProperties.renderOverlayTexture;
            this.color = renderProperties.color;
        }

        public boolean isVaporizedOnPlacement(Level level, BlockPos pos, FluidStack stack) {
            return false;
        }

        public IClientFluidTypeExtensions getClientExtensions() {
            return new IClientFluidTypeExtensions(){

                @NotNull
                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                @NotNull
                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public ResourceLocation getOverlayTexture() {
                    return overlayTexture;
                }

                @Nullable
                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return renderOverlayTexture;
                }

                @NotNull
                public Vector3f modifyFogColor(@NotNull Camera camera, float partialTick, @NotNull ClientLevel level, int renderDistance, float darkenWorldAmount, @NotNull Vector3f fluidFogColor) {
                    return new Vector3f(RenderUtil.getRed(color), RenderUtil.getGreen(color), RenderUtil.getBlue(color));
                }

                public void modifyFogRender(@NotNull Camera camera, @NotNull // Could not load outer class - annotation placement on inner may be incorrect
                 @NotNull @NotNull FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, @NotNull FogShape shape) {
                    farDistance = 24.0f;
                    if (farDistance > renderDistance) {
                        farDistance = renderDistance;
                        shape = FogShape.CYLINDER;
                    }
                    RenderSystem.setShaderFogStart((float)-8.0f);
                    RenderSystem.setShaderFogEnd((float)farDistance);
                    RenderSystem.setShaderFogShape((FogShape)shape);
                }

                public void renderOverlay(Minecraft mc, PoseStack poseStack) {
                    super.renderOverlay(mc, poseStack);
                }

                public int getTintColor() {
                    return color;
                }
            };
        }
    }
}

