/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.core.block.colored;

import com.benbenlaw.core.block.colored.util.ColorMap;
import com.benbenlaw.core.block.colored.util.IColored;
import com.benbenlaw.core.item.CoreDataComponents;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColoredSapling
extends SaplingBlock
implements IColored {
    public static Map<DyeColor, TreeGrower> treeGrowerMap = new HashMap<DyeColor, TreeGrower>();
    public static final EnumProperty<DyeColor> COLOR = EnumProperty.create((String)"color", DyeColor.class);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static TreeGrower updatedTreeGrower = null;

    public ColoredSapling(TreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(updatedTreeGrower, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public void advanceTree(ServerLevel p_222001_, BlockPos p_222002_, BlockState p_222003_, RandomSource p_222004_) {
        this.performBonemeal(p_222001_, p_222004_, p_222002_, p_222003_);
    }

    public boolean onTreeGrow(BlockState state, LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        DyeColor color = (DyeColor)state.getValue(COLOR);
        TreeGrower treeGrower = treeGrowerMap.get(color);
        if (treeGrower != null) {
            treeGrower.growTree((ServerLevel)level, ((ServerLevel)level).getChunkSource().getGenerator(), pos, state, randomSource);
            return true;
        }
        return super.onTreeGrow(state, level, placeFunction, randomSource, pos, config);
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        DyeColor color = (DyeColor)state.getValue(COLOR);
        TreeGrower treeGrower = treeGrowerMap.get(color);
        updatedTreeGrower = treeGrowerMap.get(color);
        if (treeGrower != null) {
            treeGrower.growTree(world, world.getChunkSource().getGenerator(), pos, state, random);
        }
    }

    public static void updateTreeGrowerMap(DyeColor color, TreeGrower treeGrower) {
        treeGrowerMap.put(color, treeGrower);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55484_) {
        p_55484_.add(new Property[]{LIT, COLOR, STAGE});
    }

    @Override
    public int getColor(int index) {
        DyeColor color = DyeColor.values()[index % DyeColor.values().length];
        return ColorMap.getColorValue(color);
    }

    @Override
    public int getColor(int index, ItemStack stack) {
        return this.getColor(index);
    }

    @NotNull
    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        DyeColor color = (DyeColor)state.getValue(COLOR);
        for (ItemStack drop : drops) {
            if (!(drop.getItem() instanceof BlockItem) || ((BlockItem)drop.getItem()).getBlock() != this) continue;
            drop.set(CoreDataComponents.COLOR, (Object)color.toString());
            drop.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (state.getBlock() instanceof ColoredSapling) {
            DyeColor color = (DyeColor)state.getValue(COLOR);
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(CoreDataComponents.COLOR, (Object)color.toString());
            stack.set(CoreDataComponents.LIT, (Object)((Boolean)state.getValue((Property)LIT)));
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (stack.get(CoreDataComponents.COLOR) != null && stack.get(CoreDataComponents.LIT) != null) {
            String colorString = (String)stack.get(CoreDataComponents.COLOR);
            assert (colorString != null);
            DyeColor dyeColor = ColorMap.getDyeColor(colorString);
            Boolean lit = (Boolean)stack.get(CoreDataComponents.LIT);
            assert (lit != null);
            BlockState newState = (BlockState)((BlockState)state.setValue(COLOR, (Comparable)dyeColor)).setValue((Property)LIT, (Comparable)lit);
            level.setBlockAndUpdate(pos, newState);
        } else {
            level.setBlockAndUpdate(pos, state);
        }
    }
}

