/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.ftbquests.recipemod_common;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.integration.item_filtering.ItemMatchingSystem;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.loot.RewardTable;
import dev.ftb.mods.ftbquests.quest.loot.WeightedReward;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.ItemTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class WrappedQuest {
    public final Quest quest;
    public final List<List<ItemStack>> input;
    public final List<List<ItemStack>> output;

    public WrappedQuest(Quest q, List<Reward> rewards) {
        ItemIcon itemIcon;
        Icon icon;
        this.quest = q;
        this.input = new ArrayList<List<ItemStack>>(5);
        this.output = new ArrayList<List<ItemStack>>(5);
        if (this.quest.getTasks().size() == 1) {
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
            this.input.add(Collections.emptyList());
        }
        for (Task task : this.quest.getTasks()) {
            ItemStack stack;
            if (task instanceof ItemTask) {
                ItemTask itemTask = (ItemTask)task;
                this.input.add(Collections.singletonList(itemTask.getItemStack()));
                continue;
            }
            Object object = task.getIcon().getIngredient();
            ItemStack itemStack = stack = object instanceof ItemStack ? (ItemStack)object : ItemStack.EMPTY;
            if (!stack.isEmpty()) {
                this.input.add(List.copyOf(ItemMatchingSystem.INSTANCE.getAllMatchingStacks(stack, q.getQuestFile().holderLookup())));
                continue;
            }
            icon = task.getIcon();
            if (icon instanceof ItemIcon) {
                itemIcon = (ItemIcon)icon;
                stack = itemIcon.getStack().copy();
                stack.set(DataComponents.CUSTOM_NAME, (Object)task.getTitle());
                this.input.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((ItemLike)Items.PAINTING);
            stack.set(DataComponents.CUSTOM_NAME, (Object)task.getTitle());
            this.input.add(Collections.singletonList(stack));
        }
        if (rewards.size() == 1) {
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
            this.output.add(Collections.emptyList());
        }
        for (Reward reward : rewards) {
            Object object = reward.getIcon().getIngredient();
            ItemStack stack = ItemStack.EMPTY;
            if (object instanceof ItemStack) {
                ItemStack s;
                stack = s = (ItemStack)object;
            }
            if (!stack.isEmpty()) {
                this.output.add(Collections.singletonList(stack.copy()));
                continue;
            }
            if (reward instanceof RandomReward) {
                RandomReward r = (RandomReward)reward;
                RewardTable table = r.getTable();
                if (table == null) continue;
                ImmutableList.Builder builder = ImmutableList.builder();
                if (table.shouldShowTooltip()) {
                    ItemStack unknown = new ItemStack((ItemLike)Items.BARRIER);
                    unknown.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Unknown Reward"));
                    builder.add((Object)unknown);
                } else {
                    for (WeightedReward wr : table.getWeightedRewards()) {
                        Object object2 = wr.getReward().getIcon().getIngredient();
                        if (!(object2 instanceof ItemStack)) continue;
                        ItemStack s = (ItemStack)object2;
                        builder.add((Object)s);
                    }
                }
                this.output.add((List<ItemStack>)builder.build());
                continue;
            }
            icon = reward.getIcon();
            if (icon instanceof ItemIcon) {
                itemIcon = (ItemIcon)icon;
                stack = itemIcon.getStack().copy();
                stack.set(DataComponents.CUSTOM_NAME, (Object)reward.getTitle());
                this.output.add(Collections.singletonList(stack));
                continue;
            }
            stack = new ItemStack((ItemLike)Items.PAINTING);
            stack.set(DataComponents.CUSTOM_NAME, (Object)reward.getTitle());
            this.output.add(Collections.singletonList(stack));
        }
    }

    public List<Ingredient> inputIngredients() {
        return this.input.stream().map(items -> Ingredient.of((ItemStack[])items.toArray(new ItemStack[0]))).toList();
    }

    public List<Ingredient> outputIngredients() {
        return this.output.stream().map(items -> Ingredient.of((ItemStack[])items.toArray(new ItemStack[0]))).toList();
    }

    public boolean hasInput(ItemStack stack) {
        return this.input.stream().flatMap(Collection::stream).anyMatch(stack1 -> ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack));
    }

    public boolean hasOutput(ItemStack stack) {
        return this.output.stream().flatMap(Collection::stream).anyMatch(stack1 -> ItemStack.isSameItemSameComponents((ItemStack)stack1, (ItemStack)stack));
    }

    public void openQuestGui() {
        ClientQuestFile.openGui((Quest)this.quest, (boolean)true);
    }
}

