/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.client.gui.config.widgets;

import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothConfigButtonEntry
extends AbstractConfigListEntry<Void> {
    private final Button button;
    private final Button deleteButton;
    private final Component displayName;
    private final boolean hasDeleteButton;
    private final boolean wasEdited;

    public ClothConfigButtonEntry(Component displayName, Component fieldName, @Nullable Button.OnPress onPress) {
        this(displayName, fieldName, onPress, null, false);
    }

    public ClothConfigButtonEntry(Component displayName, Component fieldName, Button.OnPress onPress, @Nullable Button.OnPress deletePress, boolean wasEdited) {
        super(fieldName, false);
        this.hasDeleteButton = deletePress != null;
        this.wasEdited = wasEdited;
        int mainButtonWidth = this.hasDeleteButton ? 75 : 100;
        this.button = Button.builder((Component)fieldName, (Button.OnPress)onPress).size(mainButtonWidth, 20).pos(0, 0).build();
        this.deleteButton = deletePress != null ? Button.builder((Component)Component.literal((String)"X"), (Button.OnPress)deletePress).size(20, 20).pos(0, 0).build() : null;
        this.displayName = displayName;
    }

    public void render(GuiGraphics matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Window window = Minecraft.getInstance().getWindow();
        Component displayedFieldName = this.displayName;
        if (Minecraft.getInstance().font.isBidirectional()) {
            matrices.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), window.getGuiScaledWidth() - x - Minecraft.getInstance().font.width((FormattedText)displayedFieldName), y + 6, 0xFFFFFF);
            this.button.setX(x);
            if (this.hasDeleteButton) {
                this.deleteButton.setX(x + this.button.getWidth() + 4);
            }
        } else {
            matrices.drawString(Minecraft.getInstance().font, displayedFieldName.getVisualOrderText(), x, y + 6, this.getPreferredTextColor());
            if (this.hasDeleteButton) {
                this.button.setX(x + entryWidth - this.button.getWidth() - 24);
                this.deleteButton.setX(x + entryWidth - 20);
            } else {
                this.button.setX(x + entryWidth - this.button.getWidth());
            }
        }
        this.button.setY(y + (entryHeight - 20) / 2);
        this.button.render(matrices, mouseX, mouseY, delta);
        if (this.hasDeleteButton) {
            this.deleteButton.setY(y + (entryHeight - 20) / 2);
            this.deleteButton.render(matrices, mouseX, mouseY, delta);
        }
    }

    public Void getValue() {
        return null;
    }

    public Optional<Void> getDefaultValue() {
        return Optional.empty();
    }

    public void save() {
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        ArrayList<Button> children = new ArrayList<Button>();
        children.add(this.button);
        if (this.hasDeleteButton) {
            children.add(this.deleteButton);
        }
        return children;
    }

    public List<? extends NarratableEntry> narratables() {
        ArrayList<Button> children = new ArrayList<Button>();
        children.add(this.button);
        if (this.hasDeleteButton) {
            children.add(this.deleteButton);
        }
        return children;
    }

    public boolean isEdited() {
        return this.wasEdited;
    }
}

