/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.mixin;

import com.almostreliable.kubeio.KubePlugin;
import com.enderio.machines.common.blocks.alloy.AlloySmeltingRecipe;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Inject(method={"lambda$apply$0"}, at={@At(value="HEAD")})
    private static void kubeio$injectSmeltingRecipes(ResourceLocation id, ImmutableMultimap.Builder<RecipeType<?>, RecipeHolder<?>> byTypeBuilder, ImmutableMap.Builder<ResourceLocation, RecipeHolder<?>> byNameBuilder, WithConditions<Recipe<?>> condRecipe, CallbackInfo ci) {
        if (!KubePlugin.SMELTING_RECIPES.contains(id)) {
            return;
        }
        KubePlugin.SMELTING_RECIPES.remove(id);
        Recipe recipe = (Recipe)condRecipe.carrier();
        if (!(recipe instanceof AlloySmeltingRecipe)) {
            return;
        }
        AlloySmeltingRecipe alloyRecipe = (AlloySmeltingRecipe)recipe;
        List inputs = alloyRecipe.inputs();
        if (inputs.size() != 1 || ((SizedIngredient)inputs.getFirst()).count() != 1) {
            return;
        }
        Ingredient input = ((SizedIngredient)inputs.getFirst()).ingredient();
        ItemStack output = alloyRecipe.output();
        float experience = alloyRecipe.experience();
        ResourceLocation inheritedId = ResourceLocation.tryParse((String)(String.valueOf(id) + "_inherited"));
        if (inheritedId == null) {
            return;
        }
        RecipeHolder holder = new RecipeHolder(inheritedId, (Recipe)new SmeltingRecipe("", CookingBookCategory.MISC, input, output, experience, 200));
        byTypeBuilder.put((Object)RecipeType.SMELTING, (Object)holder);
        byNameBuilder.put((Object)inheritedId, (Object)holder);
    }
}

