/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.component;

import com.almostreliable.kubeio.binding.SagMillOutputItem;
import com.almostreliable.kubeio.mixin.IngredientAccessor;
import com.almostreliable.kubeio.mixin.SagMillOutputItemAccessor;
import com.almostreliable.kubeio.mixin.TagValueAccessor;
import com.enderio.base.api.EnderIO;
import com.enderio.machines.common.blocks.sag_mill.SagMillingRecipe;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.error.InvalidRecipeComponentValueException;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.IngredientWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.ItemWrapper;
import dev.latvian.mods.kubejs.plugin.builtin.wrapper.SizedIngredientWrapper;
import dev.latvian.mods.kubejs.recipe.RecipeScriptContext;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponentType;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record SagMillOutputItemComponent(RecipeComponentType<?> type) implements RecipeComponent<SagMillingRecipe.OutputItem>
{
    public static final RecipeComponentType<SagMillingRecipe.OutputItem> TYPE = RecipeComponentType.unit((ResourceLocation)EnderIO.loc((String)"sag_mill_output"), SagMillOutputItemComponent::new);
    private static final SagMillingRecipe.OutputItem EMPTY = SagMillOutputItem.kubeio$of(ItemStack.EMPTY);

    public Codec<SagMillingRecipe.OutputItem> codec() {
        return SagMillOutputItemAccessor.getCodec();
    }

    public TypeInfo typeInfo() {
        return TypeInfo.of(SagMillingRecipe.OutputItem.class).or(SizedIngredientWrapper.TYPE_INFO).or(IngredientWrapper.TYPE_INFO).or(ItemWrapper.TYPE_INFO);
    }

    public SagMillingRecipe.OutputItem wrap(RecipeScriptContext cx, Object from) {
        if (from instanceof SagMillingRecipe.OutputItem) {
            SagMillingRecipe.OutputItem o = (SagMillingRecipe.OutputItem)from;
            return o;
        }
        SizedIngredient sizedIngredient = SizedIngredientWrapper.wrap((Context)cx.cx(), (Object)from);
        Ingredient.Value[] ingredientValues = ((IngredientAccessor)sizedIngredient.ingredient()).kubeio$getValues();
        if (ingredientValues.length == 0) {
            return EMPTY;
        }
        if (ingredientValues.length > 1) {
            throw new InvalidRecipeComponentValueException("compound ingredients not supported in sag mill output", (RecipeComponent)this, from).source(cx.recipe().sourceLine);
        }
        Ingredient.Value ingredientValue = ingredientValues[0];
        if (ingredientValue instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)ingredientValue;
            TagKey<Item> tag = ((TagValueAccessor)tagValue).kubeio$getTag();
            return SagMillOutputItem.kubeio$ofTag(tag, sizedIngredient.count());
        }
        if (ingredientValue instanceof Ingredient.ItemValue) {
            Ingredient.ItemValue itemValue = (Ingredient.ItemValue)ingredientValue;
            Collection items = itemValue.getItems();
            if (items.isEmpty()) {
                return EMPTY;
            }
            if (items.size() > 1) {
                throw new InvalidRecipeComponentValueException("compound ingredients not supported in sag mill output", (RecipeComponent)this, from).source(cx.recipe().sourceLine);
            }
            ItemStack itemStack = new ItemStack((ItemLike)((ItemStack)items.iterator().next()).getItem(), sizedIngredient.count());
            return SagMillOutputItem.kubeio$of(itemStack);
        }
        ItemStack itemStack = ItemWrapper.wrap((Context)cx.cx(), (Object)from);
        return itemStack.isEmpty() ? EMPTY : SagMillOutputItem.kubeio$of(itemStack);
    }

    public boolean isEmpty(SagMillingRecipe.OutputItem value) {
        return value == EMPTY || !value.isPresent();
    }
}

