/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.tiab_charger.util;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyDisplayTooltipArea {
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private final IEnergyStorage energy;

    public EnergyDisplayTooltipArea(int xMin, int yMin, IEnergyStorage energy) {
        this(xMin, yMin, energy, 8, 64);
    }

    public EnergyDisplayTooltipArea(int xMin, int yMin, IEnergyStorage energy, int width, int height) {
        this.xPos = xMin;
        this.yPos = yMin;
        this.width = width;
        this.height = height;
        this.energy = energy;
    }

    public List<Component> getTooltips() {
        return List.of(Component.literal((String)(this.energy.getEnergyStored() + " / " + this.energy.getMaxEnergyStored() + " FE")));
    }

    public void render(GuiGraphics guiGraphics) {
        int stored = (int)((float)this.height * ((float)this.energy.getEnergyStored() / (float)this.energy.getMaxEnergyStored()));
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"tiab_charger", (String)"textures/gui/charger.png"), this.xPos, this.yPos + (this.height - stored), 176, 0, this.width, stored);
    }
}

