/*
 * Decompiled with CFR 0.152.
 */
package io.github.projectet.ae2things.util;

import io.github.projectet.ae2things.util.DataStorage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class StorageManager
extends SavedData {
    private static final SavedData.Factory<StorageManager> FACTORY = new SavedData.Factory(StorageManager::new, StorageManager::readNbt);
    private static final String DISKUUID = "disk_id";
    private final Map<UUID, DataStorage> disks;
    @Nullable
    private WeakReference<HolderLookup.Provider> registries;

    public StorageManager() {
        this.disks = new HashMap<UUID, DataStorage>();
        this.setDirty();
    }

    private StorageManager(Map<UUID, DataStorage> disks) {
        this.disks = disks;
        this.setDirty();
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag diskList = new ListTag();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            CompoundTag disk = new CompoundTag();
            disk.putUUID(DISKUUID, entry.getKey());
            disk.put("diskdata", (Tag)entry.getValue().toNbt());
            diskList.add((Object)disk);
        }
        nbt.put("disklist", (Tag)diskList);
        return nbt;
    }

    public static StorageManager readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        HashMap<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();
        ListTag diskList = nbt.getList("disklist", 10);
        for (int i = 0; i < diskList.size(); ++i) {
            CompoundTag disk = diskList.getCompound(i);
            disks.put(disk.getUUID(DISKUUID), DataStorage.fromNbt(disk.getCompound("diskdata")));
        }
        return new StorageManager(disks);
    }

    public void updateDisk(UUID uuid, DataStorage dataStorage) {
        this.disks.put(uuid, dataStorage);
        this.setDirty();
    }

    public void removeDisk(UUID uuid) {
        this.disks.remove(uuid);
        this.setDirty();
    }

    public boolean hasUUID(UUID uuid) {
        return this.disks.containsKey(uuid);
    }

    public DataStorage getOrCreateDisk(UUID uuid) {
        if (!this.disks.containsKey(uuid)) {
            this.updateDisk(uuid, new DataStorage());
        }
        return this.disks.get(uuid);
    }

    public void modifyDisk(UUID diskID, ListTag stackKeys, long[] stackAmounts, long itemCount) {
        DataStorage diskToModify = this.getOrCreateDisk(diskID);
        if (stackKeys != null && stackAmounts != null) {
            diskToModify.stackKeys = stackKeys;
            diskToModify.stackAmounts = stackAmounts;
        }
        diskToModify.itemCount = itemCount;
        this.updateDisk(diskID, diskToModify);
    }

    public static StorageManager getInstance(MinecraftServer server) {
        ServerLevel world = server.getLevel(ServerLevel.OVERWORLD);
        StorageManager manager = (StorageManager)world.getDataStorage().computeIfAbsent(FACTORY, "disk_manager");
        manager.registries = new WeakReference<RegistryAccess.Frozen>(server.registryAccess());
        return manager;
    }

    public HolderLookup.Provider getRegistries() {
        WeakReference<HolderLookup.Provider> r = this.registries;
        if (r == null) {
            throw new IllegalStateException("StorageManager was not initialized properly.");
        }
        HolderLookup.Provider registries = (HolderLookup.Provider)r.get();
        if (registries == null) {
            throw new IllegalStateException("Using a StorageManager whose server was already closed");
        }
        return registries;
    }
}

