/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.handler;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import xueluoanping.fluiddrawerslegacy.api.exchange.FluidExchangeHandlerManager;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.handler.FluidUtilPatch;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class InteractWithBlockHandler {
    @SubscribeEvent
    public static void onInteractWithBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        Direction face = event.getFace();
        BlockState state = world.getBlockState(pos);
        ItemStack stack = event.getItemStack();
        if (state.getBlock() != ModBlocks.CONTROLLER.get() || face != state.getValue((Property)BlockController.FACING)) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof BlockEntityController) {
            BlockEntityController tile = (BlockEntityController)blockEntity;
            if (event.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, pos, null) != null) {
                ArrayList<FluidStack> fluidStacksList = FluidExchangeHandlerManager.getFluidInItemContainer(stack);
                if (fluidStacksList.isEmpty()) {
                    return;
                }
                IFluidHandler fluidHandler = (IFluidHandler)event.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, pos, null);
                FluidStack fluidStack = FluidStack.EMPTY;
                boolean isExist = false;
                for (FluidStack stack1 : fluidStacksList) {
                    if (fluidHandler.drain(stack1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) continue;
                    isExist = true;
                    fluidStack = stack1;
                    break;
                }
                if (isExist && (FluidExchangeHandlerManager.tryHandleClickInputByMod(tile, event.getEntity(), event.getHand()) || FluidUtilPatch.interactWithFluidHandlerAndEmpty(event.getEntity(), event.getHand(), fluidHandler, fluidStack))) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    return;
                }
                Optional.ofNullable((IDrawerGroup)tile.getCapability(Capabilities.DRAWER_GROUP)).ifPresent(handler -> {
                    if (handler.isGroupValid() && handler.getDrawerCount() > 0) {
                        for (int i = 0; i < handler.getDrawerCount(); ++i) {
                            IDrawer drawer = handler.getDrawer(i);
                            if (drawer instanceof BlockEntityFluidDrawer.FluidGroupData) {
                                BlockEntityFluidDrawer.FluidGroupData fluiddrawer = (BlockEntityFluidDrawer.FluidGroupData)drawer;
                                continue;
                            }
                            if (drawer.canItemBeStored(stack) && drawer.getStoredItemPrototype().is(stack.getItem())) break;
                        }
                    }
                });
            }
        }
    }
}

