/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.handler;

import com.google.common.base.Preconditions;
import cpw.mods.util.Lazy;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidUtilPatch {
    public static boolean interactWithFluidHandlerAndEmpty(@NotNull Player player, @NotNull InteractionHand hand, @NotNull IFluidHandler handler, FluidStack fluidStack) {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)hand);
        Preconditions.checkNotNull((Object)handler);
        ItemStack heldItem = player.getItemInHand(hand);
        if (!heldItem.isEmpty()) {
            return (Boolean)Lazy.of((Object)((IItemHandler)player.getCapability(Capabilities.ItemHandler.ENTITY))).map(playerInventory -> {
                FluidActionResult fluidActionResult = FluidUtilPatch.tryEmptyContainerAndStow(heldItem, handler, playerInventory, fluidStack, player, true);
                if (fluidActionResult.isSuccess()) {
                    player.setItemInHand(hand, fluidActionResult.getResult());
                    return true;
                }
                return false;
            }).orElse((Object)false);
        }
        return false;
    }

    public static FluidActionResult tryEmptyContainerAndStow(@NotNull ItemStack container, IFluidHandler fluidDestination, IItemHandler inventory, FluidStack fluidStack, @Nullable Player player, boolean doDrain) {
        if (container.isEmpty()) {
            return FluidActionResult.FAILURE;
        }
        if (player != null && player.getAbilities().instabuild) {
            FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return new FluidActionResult(container);
            }
        } else if (container.getCount() == 1) {
            FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
            if (emptiedReal.isSuccess()) {
                return emptiedReal;
            }
        } else {
            ItemStack remainder;
            FluidActionResult emptiedSimulated = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, false);
            if (emptiedSimulated.isSuccess() && ((remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedSimulated.getResult(), (boolean)true)).isEmpty() || player != null)) {
                FluidActionResult emptiedReal = FluidUtilPatch.tryEmptyContainer(container, fluidDestination, fluidStack, player, doDrain);
                remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)emptiedReal.getResult(), (!doDrain ? 1 : 0) != 0);
                if (!remainder.isEmpty() && player != null && doDrain) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)remainder);
                }
                ItemStack containerCopy = container.copy();
                containerCopy.shrink(1);
                return new FluidActionResult(containerCopy);
            }
        }
        return FluidActionResult.FAILURE;
    }

    @NotNull
    public static FluidActionResult tryEmptyContainer(@NotNull ItemStack container, IFluidHandler fluidDestination, FluidStack fluidStack, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = container.copyWithCount(1);
        return (FluidActionResult)FluidUtilPatch.getFluidHandler(containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (FluidStack)fluidStack, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (!doDrain) {
                containerFluidHandler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(transfer, SoundActions.BUCKET_EMPTY)) != null) {
                player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse((Object)FluidActionResult.FAILURE);
    }

    @Nullable
    public static Lazy<IFluidHandlerItem> getFluidHandler(@NotNull ItemStack itemStack) {
        return Lazy.of((Object)((IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM)));
    }
}

