/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.data.recipe;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.util.RegisterFinderUtil;

public class RecipeDataProvider
extends RecipeProvider {
    public RecipeDataProvider(PackOutput generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(generator, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput pRecipeOutput, HolderLookup.Provider holderLookup) {
        super.buildRecipes(pRecipeOutput, holderLookup);
        this.buildFluidDrawerRecipe(pRecipeOutput, "", 1, "///", " X ", "///");
        this.buildFluidDrawerRecipe(pRecipeOutput, "_2", 2, "/X/", "///", "/X/");
        this.buildFluidDrawerRecipe(pRecipeOutput, "_4", 4, "X/X", "///", "X/X");
        this.buildFluidDrawerRecipeHalf(pRecipeOutput, "_half", 1, "///", " X ", "///");
        this.buildFluidDrawerRecipeHalf(pRecipeOutput, "_2_half", 2, "/X/", "///", "/X/");
        this.buildFluidDrawerRecipeHalf(pRecipeOutput, "_4_half", 4, "X/X", "///", "X/X");
    }

    private void buildFluidDrawerRecipe(RecipeOutput pRecipeOutput, String countString, int count, String ... pattern) {
        ShapedRecipeBuilder a = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.getDrawerWith(countString), (int)count);
        for (String s : pattern) {
            a = a.pattern(s);
        }
        a.define(Character.valueOf('/'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('X'), (ItemLike)Items.BUCKET).unlockedBy("has_bucket", RecipeDataProvider.has((ItemLike)Items.BUCKET)).save(pRecipeOutput);
    }

    private void buildFluidDrawerRecipeHalf(RecipeOutput pRecipeOutput, String countString, int count, String ... pattern) {
        ShapedRecipeBuilder a = ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.getDrawerWith(countString), (int)count);
        for (String s : pattern) {
            a = a.pattern(s);
        }
        a.define(Character.valueOf('/'), Tags.Items.GLASS_PANES).define(Character.valueOf('X'), (ItemLike)Items.BUCKET).unlockedBy("has_bucket", RecipeDataProvider.has((ItemLike)Items.BUCKET)).save(pRecipeOutput);
    }

    private Item getDrawerWith(String countString) {
        return RegisterFinderUtil.getItem(FluidDrawersLegacyMod.rl("fluiddrawer" + countString));
    }
}

