/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.data.loot;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.util.RegisterFinderUtil;

public class DrawerBlockLootTables
extends BlockLootSubProvider {
    private final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();

    public DrawerBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    private Block getDrawerWith(String countString) {
        return RegisterFinderUtil.getBlock(FluidDrawersLegacyMod.rl("fluiddrawer" + countString));
    }

    protected void generate() {
        this.add(this.getDrawerWith(""), this::createSingleDrawerTable);
        this.add(this.getDrawerWith("_2"), this::createSingleDrawerTable);
        this.add(this.getDrawerWith("_4"), this::createSingleDrawerTable);
        this.add(this.getDrawerWith("_half"), this::createSingleDrawerTable);
        this.add(this.getDrawerWith("_2_half"), this::createSingleDrawerTable);
        this.add(this.getDrawerWith("_4_half"), this::createSingleDrawerTable);
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModContents.DREntityBlocks.getEntries().stream().map(DeferredHolder::get).collect(Collectors.toList());
    }

    public LootTable.Builder createSingleDrawerTable(ItemLike item) {
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)item.asItem(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)))).apply((LootItemFunction.Builder)CopyCustomDataFunction.copyData((NbtProvider)ContextNbtProvider.BLOCK_ENTITY).copy("tanks", "tanks").copy("Upgrades", "Upgrades").copy("Lock", "Lock").copy("Shr", "Shr").copy("Qua", "Qua"));
    }
}

