/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.data.blockstate;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.util.RegisterFinderUtil;

public class BlockStatesDataProvider
extends BlockStateProvider {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BlockStatesDataProvider(PackOutput gen, ExistingFileHelper exFileHelper) {
        super(gen, "fluiddrawerslegacy", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (DeferredHolder entry : ModContents.DREntityBlocks.getEntries()) {
            this.getVariantBuilder((Block)entry.get()).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(BlockStatesDataProvider.resourceBlock(entry.getId().getPath()))).rotationY(BlockStatesDataProvider.getRotateYByFacing(state)).build(), new Property[0]);
        }
    }

    public void customStageBlock(Block block, @Nullable ResourceLocation parent, String textureKey, IntegerProperty ageProperty, List<Integer> suffixes, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int ageSuffix = (Integer)state.getValue((Property)ageProperty);
            String stageName = this.blockName(block) + "_stage_";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size() - 1, ageSuffix)));
            if (parent == null) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().cross(stageName, BlockStatesDataProvider.resourceBlock(stageName))).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().singleTexture(stageName, parent, textureKey, BlockStatesDataProvider.resourceBlock(stageName))).build();
        }, ignored);
    }

    private String blockName(Block block) {
        return RegisterFinderUtil.getBlockKey(block).getPath();
    }

    public static ResourceLocation resourceBlock(String path) {
        return FluidDrawersLegacyMod.rl("block/" + path);
    }

    public ResourceLocation resourceVanillaBlock(String path) {
        return ResourceLocation.withDefaultNamespace((String)("block/" + path));
    }

    public static int getRotateYByFacing(BlockState state) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case EAST: {
                return 90;
            }
            case SOUTH: {
                return 180;
            }
            case WEST: {
                return 270;
            }
        }
        return 0;
    }
}

