/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.compat.jade;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import java.util.Optional;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import snownee.jade.addon.universal.FluidStorageProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.api.drawer.BetterFluidManager;
import xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;

public class FluidDrawerProvider
implements IBlockComponentProvider {
    public static FluidDrawerProvider INSTANCE = new FluidDrawerProvider();

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity tileEntity;
        tooltip.remove(JadeIds.UNIVERSAL_FLUID_STORAGE);
        tooltip.remove(JadeIds.UNIVERSAL_FLUID_STORAGE_DETAILED);
        if (accessor.getBlock() instanceof BlockFluidDrawer && (tileEntity = accessor.getLevel().getBlockEntity(accessor.getPosition())) instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            Optional.ofNullable((IFluidHandler)accessor.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, accessor.getPosition(), null)).ifPresent(handler -> {
                int capacity = tile.getCapacityTankEffective();
                boolean isLocked = tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
                if (handler instanceof BetterFluidManager) {
                    BetterFluidManager h = (BetterFluidManager)handler;
                    for (BlockEntityFluidDrawer.FluidDrawerData data : h.getFluidDrawerDataList()) {
                        BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = data.getTank();
                        FluidStack fluidStack = betterFluidHandler2.getFluid().copy();
                        FluidStack cache = betterFluidHandler2.getCacheFluid();
                        FluidDrawerProvider.appendTank(tooltip, accessor, fluidStack, capacity, cache, isLocked);
                    }
                }
            });
        }
    }

    public static void appendTank(ITooltip tooltip, BlockAccessor accessor, FluidStack fluidStack, int capacity, FluidStack cacheFluid, boolean isLocked) {
        if (capacity > 0) {
            MutableComponent text;
            IElementHelper helper = IElementHelper.get();
            if (fluidStack.isEmpty()) {
                text = Component.translatable((String)"jade.fluid.empty");
                String capacityText = DisplayHelper.INSTANCE.humanReadableNumber((double)capacity, "B", true);
                text.append("\u00a77 " + capacityText);
                if (isLocked) {
                    text = Component.translatable((String)(I18n.get((String)new FluidStack(cacheFluid.getFluidHolder(), 1).getHoverName().getString(), (Object[])new Object[0]) + " 0B \u00a7e(" + I18n.get((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ") "));
                }
            } else {
                String amountText = DisplayHelper.INSTANCE.humanReadableNumber((double)fluidStack.getAmount(), "B", true);
                MutableComponent mutableComponent = text = isLocked ? Component.translatable((String)"jade.fluid", (Object[])new Object[]{fluidStack.getHoverName(), amountText}).append(" \u00a7e(" + I18n.get((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ") ") : Component.translatable((String)"jade.fluid", (Object[])new Object[]{fluidStack.getHoverName(), amountText});
                if (accessor.getPlayer().isShiftKeyDown()) {
                    String capacityText = DisplayHelper.INSTANCE.humanReadableNumber((double)capacity, "B", true);
                    text.append("\u00a77 / " + capacityText);
                }
            }
            ProgressStyle progressStyle = helper.progressStyle().overlay(helper.fluid(JadeFluidObject.of((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (DataComponentPatch)fluidStack.getComponentsPatch())));
            tooltip.add(helper.progress((float)fluidStack.getAmount() / (float)capacity, (Component)text, progressStyle, BoxStyle.getNestedBox(), true));
        }
    }

    public ResourceLocation getUid() {
        return FluidDrawersLegacyMod.rl("fluiddrawer");
    }

    public int getDefaultPriority() {
        return FluidStorageProvider.ForBlock.getBlock().getDefaultPriority() + 1000;
    }
}

