/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import xueluoanping.fluiddrawerslegacy.client.util.TankHolder;
import xueluoanping.fluiddrawerslegacy.util.MathUtils;

public class TankRenderUtil {
    public static void addVertex(VertexConsumer renderer, PoseStack stack, float x, float y, float z, float u, float v, int RGBA, float alpha, int brightness) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA >> 0 & 0xFF) / 255.0f;
        int light1 = brightness & 0xFFFF;
        int light2 = brightness >> 16 & 0xFFFF;
        renderer.addVertex(stack.last().pose(), x, y, z).setColor(red, green, blue, alpha).setUv(u, v).setUv2(light1, light2).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(stack.last(), 0.0f, 1.0f, 0.0f);
    }

    public static void renderFluid(ArrayList<TankHolder> fluidStacks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime, boolean isHalf) {
        TankRenderUtil.renderFluid(fluidStacks, matrixStackIn, bufferIn, combinedLight, animationTime, isHalf, Direction.NORTH);
    }

    public static void renderFluid(ArrayList<TankHolder> fluidStacks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime, boolean isHalf, Direction direction) {
        int count = fluidStacks.size();
        int slot = 0;
        for (TankHolder holder : fluidStacks) {
            FluidStack fluidStackDown = holder.fluidStackDown();
            int capacity = holder.capacity();
            ++slot;
            if (fluidStackDown.isEmpty() && capacity > 0) continue;
            Minecraft mc = Minecraft.getInstance();
            TextureAtlasSprite still = (TextureAtlasSprite)mc.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(IClientFluidTypeExtensions.of((Fluid)fluidStackDown.getFluid()).getStillTexture(fluidStackDown));
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
            int colorRGB = IClientFluidTypeExtensions.of((Fluid)fluidStackDown.getFluid()).getTintColor(fluidStackDown);
            int amount = fluidStackDown.getAmount();
            if (capacity < amount) {
                amount = capacity;
            }
            float r = (float)amount / (float)capacity;
            float width = 0.872f;
            float didw = 0.125f;
            float didh = 0.125f;
            float x0 = 0.064f;
            float y0 = 0.064f;
            float z0 = 0.064f;
            float x1 = 0.936f;
            float y1 = 0.064f;
            float z1 = 0.936f;
            float maxHeight = 0.872f - didh;
            float height = r * maxHeight;
            float u0 = still.getU0();
            float u1 = still.getU1();
            float du = u1 - u0;
            float v0 = still.getV0();
            float v1 = still.getV1();
            float dv = v1 - v0;
            float uHeight = du * (1.0f - r);
            float vHeight = dv * (1.0f - r);
            if (count == 4) {
                boolean orderY = false;
                boolean orderX = false;
                switch (slot) {
                    case 1: {
                        orderX = false;
                        orderY = true;
                        break;
                    }
                    case 2: {
                        orderX = true;
                        orderY = true;
                        break;
                    }
                    case 3: {
                        orderX = false;
                        orderY = false;
                        break;
                    }
                    case 4: {
                        orderX = true;
                        orderY = false;
                    }
                }
                x0 = !orderX ? x0 + (width + didw) / 2.0f : x0;
                x1 = !orderX ? x1 : x1 - (width + didw) / 2.0f;
                y1 = (y0 += (float)orderY * (didh + maxHeight / 2.0f)) + height / 2.0f;
            } else if (count == 2) {
                boolean orderY = slot == 1;
                y1 = (y0 += (float)orderY * (didh + maxHeight / 2.0f)) + height / 2.0f;
            } else {
                y1 = y0 + height + r * didh;
            }
            if (isHalf) {
                z0 += 0.5f;
            }
            VoxelShape box = MathUtils.getShapefromDirection(x0 * 16.0f, y0 * 16.0f, z0 * 16.0f, x1 * 16.0f, y1 * 16.0f, z1 * 16.0f, direction, true);
            x0 = (float)box.min(Direction.Axis.X);
            y0 = (float)box.min(Direction.Axis.Y);
            z0 = (float)box.min(Direction.Axis.Z);
            x1 = (float)box.max(Direction.Axis.X);
            y1 = (float)box.max(Direction.Axis.Y);
            z1 = (float)box.max(Direction.Axis.Z);
            matrixStackIn.pushPose();
            GlStateManager._disableCull();
            VertexConsumer buffer = bufferIn.getBuffer(RenderType.translucent());
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z1, u1, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z1, u1, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z0, u0, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z0, u0, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z0, u0, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z1, u1, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z1, u1, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z0, u0, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z0, u1, v1 - vHeight, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z0, u1, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z0, u0, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z0, u0, v1 - vHeight, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z0, u0, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z0, u1 - uHeight, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z1, u1 - uHeight, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z1, u0, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z1, u1, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y0, z1, u1, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x1, y1, z1, u0 + uHeight, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z1, u0 + uHeight, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z0, u0, v0, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y0, z1, u0, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z1, u1 - uHeight, v1, colorRGB, 1.0f, combinedLight);
            TankRenderUtil.addVertex(buffer, matrixStackIn, x0, y1, z0, u1 - uHeight, v0, colorRGB, 1.0f, combinedLight);
            GlStateManager._enableCull();
            matrixStackIn.popPose();
        }
    }

    public static TankHolder of(FluidStack stack, int cap) {
        return new TankHolder(stack, cap);
    }
}

