/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Vector3d;
import xueluoanping.fluiddrawerslegacy.api.drawer.IFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.BlockFluidDrawer;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.render.XYZ;
import xueluoanping.fluiddrawerslegacy.client.util.TankHolder;
import xueluoanping.fluiddrawerslegacy.client.util.TankRenderUtil;
import xueluoanping.fluiddrawerslegacy.config.ClientConfig;
import xueluoanping.fluiddrawerslegacy.util.MathUtil;

public class TESRFluidDrawer
implements BlockEntityRenderer<BlockEntityFluidDrawer> {
    public static final Material BELL_RESOURCE_LOCATION = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.withDefaultNamespace((String)"entity/bell/bell_body"));
    private static final String BELL_BODY = "bell_body";
    private final ModelPart bellBody;
    private final Font font;

    public TESRFluidDrawer(BlockEntityRendererProvider.Context pContext) {
        ModelPart modelpart = pContext.bakeLayer(ModelLayers.BELL);
        this.bellBody = modelpart.getChild(BELL_BODY);
        this.font = pContext.getFont();
    }

    public void render(BlockEntityFluidDrawer tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        if (!tile.hasLevel()) {
            return;
        }
        if (tile.upgrades().hasIlluminationUpgrade()) {
            combinedLightIn = 0xF000F0;
        }
        matrixStackIn.pushPose();
        Minecraft mc = Minecraft.getInstance();
        long gameTime = mc.level.getGameTime();
        double animationTime = (double)gameTime + (double)partialTicks;
        this.renderFluid(tile, matrixStackIn, bufferIn, combinedLightIn, animationTime);
        matrixStackIn.popPose();
        List<BlockEntityFluidDrawer.FluidDrawerData> dlist = tile.getTank().getFluidDrawerDataList();
        int count = dlist.size();
        int slot = 0;
        for (BlockEntityFluidDrawer.FluidDrawerData data : dlist) {
            FluidStack fluidStackDown;
            ++slot;
            BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = data.getTank();
            if (betterFluidHandler2.getCacheFluid().getFluid() != Fluids.EMPTY && tile.getDrawerAttributes().isConcealed()) {
                fluidStackDown = new FluidStack(betterFluidHandler2.getCacheFluid().getFluidHolder(), 1);
                String label = fluidStackDown.getHoverName().getString();
                this.drawText(0, label, slot, count, tile, matrixStackIn, bufferIn, combinedLightIn);
            }
            if (tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY) && betterFluidHandler2.getCacheFluid().getFluid() != Fluids.EMPTY) {
                String label = "(" + I18n.get((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ")";
                this.drawText(1, label, slot, count, tile, matrixStackIn, bufferIn, combinedLightIn);
            }
            if (!tile.getDrawerAttributes().isShowingQuantity() || betterFluidHandler2.getCacheFluid().getFluid() == Fluids.EMPTY) continue;
            fluidStackDown = betterFluidHandler2.getFluid();
            int amount = fluidStackDown.getAmount();
            String label = amount + "mB";
            this.drawText(2, label, slot, count, tile, matrixStackIn, bufferIn, combinedLightIn);
        }
    }

    private void drawText(int line, String label, int slot, int count, BlockEntityFluidDrawer tile, PoseStack matrixStackIn, MultiBufferSource txtBuffer, int combinedLightIn) {
        matrixStackIn.pushPose();
        Font fontRenderer = this.font;
        int textWidth = fontRenderer.width(label);
        Objects.requireNonNull(this.font);
        int lh = 9;
        LocalPlayer player = Minecraft.getInstance().player;
        Direction d = (Direction)tile.getBlockState().getValue((Property)BlockFluidDrawer.FACING);
        this.handleMatrixAngle(matrixStackIn, player, tile.getBlockPos(), d);
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float scale_x = 0.007f;
        float scale_y = 0.007f;
        float scale_z = 0.007f;
        float extraHeight = 0.0f;
        if (tile.isHalf()) {
            z += 0.55f;
        }
        if (count > 1) {
            scale_x /= 2.0f;
            scale_y /= 2.0f;
            scale_z /= 2.0f;
            if (count == 4) {
                if (slot == 1) {
                    x = (float)((double)x + -0.25);
                    y = (float)((double)y + -0.4);
                }
                if (slot == 2) {
                    x = (float)((double)x + 0.25);
                    y = (float)((double)y + -0.4);
                }
                if (slot == 3) {
                    x = (float)((double)x + -0.25);
                    y = (float)((double)y + 0.08);
                }
                if (slot == 4) {
                    x = (float)((double)x + 0.25);
                    y = (float)((double)y + 0.08);
                }
                if (textWidth > 80) {
                    double r = (double)textWidth / 80.0;
                    scale_x = (float)((double)scale_x / r);
                    scale_y = (float)((double)scale_y / r);
                    scale_z = (float)((double)scale_z / r);
                    extraHeight = (float)((double)lh * (r - 1.0));
                }
            }
            if (count == 2) {
                if (slot == 1) {
                    y = (float)((double)y + -0.4);
                }
                if (slot == 2) {
                    y = (float)((double)y + 0.08);
                }
            }
        }
        if (count == 1) {
            y = (float)((double)y + 0.05);
        }
        matrixStackIn.translate(x, y, z);
        matrixStackIn.scale(scale_x, scale_y, scale_z);
        fontRenderer.drawInBatch(label, (float)(-textWidth) / 2.0f, -18.0f - (float)lh * 1.2f * (float)line - 1.2f * extraHeight, 0xFFFFFF, false, matrixStackIn.last().pose(), txtBuffer, Font.DisplayMode.NORMAL, 0, combinedLightIn);
        matrixStackIn.popPose();
    }

    private void handleMatrixAngle(PoseStack matrixStackIn, LocalPlayer player, BlockPos pos, Direction d) {
        Vector3d vector3d = new Vector3d(player.getPosition(1.0f).x() - (double)pos.getX() - 0.5, player.getPosition(0.0f).y() - (double)pos.getY(), player.getPosition(0.0f).z() - (double)pos.getZ() - 0.5);
        if (d == Direction.DOWN || d == Direction.UP) {
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.EAST;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) > Math.abs(vector3d.z)) {
                d = Direction.WEST;
            }
            if (vector3d.x > 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.SOUTH;
            }
            if (vector3d.x < 0.0 && Math.abs(vector3d.x) < Math.abs(vector3d.z)) {
                d = Direction.NORTH;
            }
        }
        if ((Integer)ClientConfig.distance.get() != -1 && MathUtil.calDistanceSelf(vector3d) > (float)((Integer)ClientConfig.distance.get()).intValue()) {
            d = Direction.DOWN;
        }
        switch (d) {
            case SOUTH: {
                matrixStackIn.translate(0.5, 0.15, 1.0);
                matrixStackIn.mulPose(XYZ.deg_to_rad(0, 180, 180));
                break;
            }
            case NORTH: {
                matrixStackIn.mulPose(XYZ.deg_to_rad(0, 0, 180));
                matrixStackIn.translate(-0.5, -0.15, 0.0);
                break;
            }
            case EAST: {
                matrixStackIn.mulPose(XYZ.deg_to_rad(0, 270, 180));
                matrixStackIn.translate(-0.5, -0.15, -1.0);
                break;
            }
            case WEST: {
                matrixStackIn.mulPose(XYZ.deg_to_rad(0, 90, 180));
                matrixStackIn.translate(0.5, -0.15, 0.0);
                break;
            }
            default: {
                matrixStackIn.scale(0.01f, 0.01f, 0.01f);
            }
        }
    }

    public void render(float p_112234_, PoseStack poseStack, MultiBufferSource bufferSource, int p_112237_, int p_112238_) {
        poseStack.scale(0.001f, 0.001f, 0.001f);
        VertexConsumer vertexconsumer = BELL_RESOURCE_LOCATION.buffer(bufferSource, RenderType::entitySolid);
        this.bellBody.render(poseStack, vertexconsumer, p_112237_, p_112238_);
    }

    private void renderFluid(BlockEntityFluidDrawer tile, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        boolean isLocked = tile.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
        int count = tile.getDrawerCount();
        ArrayList<TankHolder> flist = new ArrayList<TankHolder>();
        for (int i = 0; i < count; ++i) {
            IFluidDrawer data = tile.getDrawer(i);
            Object betterFluidHandler2 = data.getTank();
            FluidStack fluidStackDown = betterFluidHandler2.getFluid().copy();
            FluidStack cache = data.getCacheFluid();
            int capacity = betterFluidHandler2.getCapacity();
            if (!fluidStackDown.isEmpty()) {
                fluidStackDown.setAmount(data.getFluidAnimation().getAndUpdateLastFluidAmount(fluidStackDown.getAmount(), animationTime));
            }
            if (isLocked && fluidStackDown.isEmpty() && !cache.isEmpty()) {
                fluidStackDown = new FluidStack(cache.getFluidHolder(), 1000);
            }
            if (tile.upgrades().hasVendingUpgrade() && !fluidStackDown.isEmpty()) {
                fluidStackDown.setAmount(capacity);
            }
            flist.add(TankRenderUtil.of(fluidStackDown, capacity));
        }
        TankRenderUtil.renderFluid(flist, matrixStackIn, bufferIn, combinedLight, animationTime, tile.isHalf(), (Direction)tile.getBlockState().getValue((Property)BlockFluidDrawer.FACING));
    }
}

