/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.render.XYZ;
import xueluoanping.fluiddrawerslegacy.client.util.TankHolder;
import xueluoanping.fluiddrawerslegacy.client.util.TankRenderUtil;

public class FluidDrawerItemStackTileEntityRenderer
extends BlockEntityWithoutLevelRenderer {
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;

    public FluidDrawerItemStackTileEntityRenderer(BlockEntityRenderDispatcher renderDispatcher, EntityModelSet modelSet) {
        super(renderDispatcher, modelSet);
        this.blockEntityRenderDispatcher = renderDispatcher;
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel ibakedmodel = itemRenderer.getModel(stack, (Level)null, (LivingEntity)null, 0);
        matrixStackIn.pushPose();
        matrixStackIn = this.rotateMatrix(matrixStackIn, transformType);
        this.renderFluid(stack, matrixStackIn, bufferIn, combinedLightIn, 0.0);
        matrixStackIn.translate(0.5f, 0.5f, 0.5f);
        itemRenderer.render(stack, ItemDisplayContext.NONE, false, matrixStackIn, bufferIn, combinedLightIn, combinedOverlay, ibakedmodel.applyTransform(ItemDisplayContext.NONE, matrixStackIn, false));
        matrixStackIn.popPose();
    }

    private PoseStack rotateMatrix(PoseStack matrixStackIn, ItemDisplayContext transformType) {
        if (transformType == ItemDisplayContext.GUI) {
            matrixStackIn.translate(0.9375f, 0.21875f, 0.0f);
            matrixStackIn.mulPose(XYZ.deg_to_rad(30, 225, 0));
            matrixStackIn.scale(0.625f, 0.625f, 0.625f);
        }
        if (transformType == ItemDisplayContext.GROUND) {
            matrixStackIn.translate(0.375, 0.375, 0.375);
            matrixStackIn.scale(0.25f, 0.25f, 0.25f);
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            matrixStackIn.mulPose(XYZ.deg_to_rad(75, 45, 0));
            matrixStackIn.translate(0.51625, 0.46875, -0.1875);
            matrixStackIn.scale(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            matrixStackIn.mulPose(XYZ.deg_to_rad(75, 45, 0));
            matrixStackIn.translate(0.51625, 0.46875, -0.1875);
            matrixStackIn.scale(0.375f, 0.375f, 0.375f);
        }
        if (transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            matrixStackIn.translate(0.40625, -0.1875, 0.0);
            matrixStackIn.mulPose(XYZ.deg_to_rad(0, 45, 0));
            matrixStackIn.scale(0.675f, 0.675f, 0.675f);
        }
        if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            matrixStackIn.translate(0.59375, -0.1875, 0.0);
            matrixStackIn.mulPose(XYZ.deg_to_rad(0, 225, 0));
            matrixStackIn.scale(0.675f, 0.675f, 0.675f);
        }
        return matrixStackIn;
    }

    private void renderFluid(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLight, double animationTime) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("tank") && !tag.contains("tanks")) {
            return;
        }
        FluidStack fluidStackDown = new FluidStack(Fluids.EMPTY, 0);
        if (tag.contains("tank")) {
            ListTag tanklist = new ListTag();
            tanklist.add((Object)tag.getCompound("tank"));
            tag.put("tanks", (Tag)tanklist);
        }
        ArrayList<TankHolder> flist = new ArrayList<TankHolder>();
        if (tag.contains("tanks")) {
            for (Tag tank : tag.getList("tanks", 10)) {
                FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)((CompoundTag)tank).getCompound("Fluid"));
                int capacity = BlockEntityFluidDrawer.calculateTankCapacityFromStack((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), stack);
                if (!fluidStack.isEmpty() && tag.toString().contains("storagedrawers:creative_vending_upgrade")) {
                    fluidStack.setAmount(capacity);
                }
                flist.add(TankRenderUtil.of(fluidStack, capacity));
            }
        }
        TankRenderUtil.renderFluid(flist, matrixStackIn, bufferIn, combinedLight, animationTime, stack.getItem().getDescriptionId().contains("half"));
    }
}

