/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.gui;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforgespi.language.IModInfo;
import org.joml.Matrix4f;
import xueluoanping.fluiddrawerslegacy.api.drawer.IFluidDrawerGroup;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.gui.ContainerFluiDrawer;

public class Screen
extends AbstractContainerScreen<ContainerFluiDrawer> {
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private final ResourceLocation background;
    private final Inventory inventory;

    public Screen(ContainerFluiDrawer container, Inventory playerInv, Component name, ResourceLocation bg) {
        super((AbstractContainerMenu)container, playerInv, name);
        this.imageWidth = 176;
        this.imageHeight = 199;
        this.background = bg;
        this.inventory = playerInv;
    }

    protected void init() {
        super.init();
    }

    public boolean hasFluidInfo() {
        boolean result = false;
        for (BlockEntityFluidDrawer.FluidDrawerData data : ((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().getTank().getFluidDrawerDataList()) {
            if (data.getTank().isEmpty()) continue;
            result = true;
        }
        return result;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        super.renderTooltip(graphics, mouseX, mouseY);
        if (this.hasFluidInfo()) {
            BlockEntityFluidDrawer tile = ((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer();
            int size = tile.getDrawerCount();
            for (int i = 0; i < size; ++i) {
                FluidStack cache;
                SlotGeometry geo = SlotGeometry.get(i + 1, size, this.width, this.height, this.imageHeight, this.imageWidth);
                if (!this.isInside(mouseX, mouseY, 17, 17, geo.left(), geo.top())) continue;
                BlockEntityFluidDrawer.betterFluidHandler tank = (BlockEntityFluidDrawer.betterFluidHandler)((Object)tile.getDrawer(i).getTank());
                FluidStack fluidStackDown = tank.getFluid();
                if (fluidStackDown.isEmpty() && !(cache = tank.getCacheFluid()).isEmpty()) {
                    fluidStackDown = new FluidStack(cache.getFluidHolder(), 1000);
                }
                if (fluidStackDown.isEmpty()) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                list.add(Component.translatable((String)(new FluidStack(fluidStackDown.getFluidHolder(), fluidStackDown.getAmount()).getHoverName().getString() + " \u00a7e" + tank.getFluidAmount() + "mB")));
                ModList modList = ModList.get();
                FluidStack finalFluidStackDown = fluidStackDown;
                Optional<Map.Entry> fluidInfo = BuiltInRegistries.FLUID.entrySet().stream().filter(resourceKeyFluidEntry -> resourceKeyFluidEntry.getValue() == finalFluidStackDown.getFluid()).findFirst();
                fluidInfo.ifPresent(resourceKeyFluidEntry -> {
                    String modId = ((ResourceKey)resourceKeyFluidEntry.getKey()).location().getNamespace();
                    Optional<String> modName = modList.getMods().stream().filter(modInfo -> modInfo.getModId().equals(modId)).map(IModInfo::getDisplayName).findFirst();
                    modName.ifPresent(s -> list.add(Component.literal((String)("\u00a79\u00a7o" + s))));
                });
                graphics.renderComponentTooltip(this.getMinecraft().font, list, mouseX, mouseY);
            }
        }
    }

    public static void buildMatrix(Matrix4f matrix, VertexConsumer builder, float x, float y, float z, float u, float v, int overlay, int RGBA, float alpha, int light) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA & 0xFF) / 255.0f;
        builder.addVertex(matrix, x, y, z).setColor(red, green, blue, alpha).setUv(u, v);
    }

    public static void buildMatrix(Matrix4f matrix, VertexConsumer builder, float x, float y, float z, float u, float v, int RGBA) {
        float red = (float)(RGBA >> 16 & 0xFF) / 255.0f;
        float green = (float)(RGBA >> 8 & 0xFF) / 255.0f;
        float blue = (float)(RGBA >> 0 & 0xFF) / 255.0f;
        boolean alpha = true;
        builder.addVertex(matrix, x, y, z).setColor(red, green, blue, (float)alpha).setUv(u, v);
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation sprite) {
        return Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(sprite);
    }

    public static void renderFluidStackInGUI(Matrix4f matrix, FluidStack fluid, int width, int height, float x, float y) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        FluidType attributes = fluid.getFluid().getFluidType();
        TextureAtlasSprite FLUID = Screen.getBlockSprite(IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(fluid));
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.BLOCK_ATLAS);
        int color = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        int wFloors = width / 16;
        int extraWidth = wFloors == 0 ? width : width % 16;
        int hFloors = height / 16;
        int extraHeight = hFloors == 0 ? height : height % 16;
        extraHeight = Math.max(1, extraHeight);
        if (height == 16) {
            extraHeight = 0;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        float u0 = FLUID.getU0();
        float v0 = FLUID.getV0();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder builder = tessellator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        for (int i = hFloors; i >= 0 && (i != 0 || extraHeight != 0); --i) {
            float yStart = y - (float)((hFloors - i) * 16);
            float yOffset = i == 0 ? (float)extraHeight : 16.0f;
            float v1 = i == 0 ? FLUID.getV0() + (FLUID.getV1() - v0) * ((float)extraHeight / 16.0f) : FLUID.getV1();
            for (int j = wFloors; j >= 0 && (j != 0 || extraWidth != 0); --j) {
                float xStart = x + (float)((wFloors - j) * 16);
                float xOffset = j == 0 ? (float)extraWidth : 16.0f;
                float u1 = j == 0 ? FLUID.getU0() + (FLUID.getU1() - u0) * ((float)extraWidth / 16.0f) : FLUID.getU1();
                Screen.buildMatrix(matrix, (VertexConsumer)builder, xStart, yStart - yOffset, 0.0f, u0, v0, color);
                Screen.buildMatrix(matrix, (VertexConsumer)builder, xStart, yStart, 0.0f, u0, v1, color);
                Screen.buildMatrix(matrix, (VertexConsumer)builder, xStart + xOffset, yStart, 0.0f, u1, v1, color);
                Screen.buildMatrix(matrix, (VertexConsumer)builder, xStart + xOffset, yStart - yOffset, 0.0f, u1, v0, color);
            }
        }
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title.getString(), 8.0f, 6.0f, 0x404040, false);
        graphics.drawString(this.font, I18n.get((String)"container.storagedrawers.upgrades", (Object[])new Object[0]), 8.0f, 75.0f, 0x404040, false);
        graphics.drawString(this.font, this.inventory.getDisplayName().getString(), 8.0f, (float)(this.imageHeight - 96 + 2), 0x404040, false);
        int amount = ((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().getCapacityTankEffective();
        String amountLabel = amount >= 1000000000 ? (int)Math.floor((float)amount / 1000.0f / 1000.0f / 1000.0f) + "M" : (amount >= 1000000 ? (int)Math.floor((float)amount / 1000.0f / 1000.0f) + "K" : (int)Math.floor((float)amount / 1000.0f) + "B");
        String mult = amountLabel;
        graphics.drawString(this.font, mult, 161 - mult.length() * 6, 42, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.background);
        int guiX = (this.width - this.imageWidth) / 2;
        int guiY = (this.height - this.imageHeight) / 2;
        graphics.blit(this.background, guiX, guiY, 0, 0, this.imageWidth, this.imageHeight);
        List<Slot> upgradeSlots = ((ContainerFluiDrawer)this.menu).getUpgradeSlots();
        for (Slot slot : upgradeSlots) {
            if (!(slot instanceof SlotUpgrade) || slot.getItem().isEmpty() || ((SlotUpgrade)slot).canTakeStack()) continue;
            graphics.blit(this.background, guiX + slot.x, guiY + slot.y, 176, 0, 16, 16);
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int slot = 0;
        List<BlockEntityFluidDrawer.FluidDrawerData> dlis = ((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().getTank().getFluidDrawerDataList();
        for (BlockEntityFluidDrawer.FluidDrawerData data : dlis) {
            int amount;
            ++slot;
            BlockEntityFluidDrawer.betterFluidHandler betterFluidHandler2 = data.getTank();
            FluidStack fluidStackDown = betterFluidHandler2.getFluid().copy();
            int capacity = ((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().getCapacityTankEffective();
            if (capacity < (amount = fluidStackDown.getAmount())) {
                amount = capacity;
            }
            float h = 0.0f;
            h = (float)amount / (float)capacity;
            if ((double)((float)amount / (float)capacity) <= 0.0625 && (double)((float)amount / (float)capacity) >= 0.01) {
                h = 0.01f;
            }
            if ((double)((float)amount / (float)capacity) > 0.9375 && (double)((float)amount / (float)capacity) < 0.99) {
                h = 0.9375f;
            }
            int h0 = (int)(h * 16.0f);
            if (((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().upgrades().hasVendingUpgrade()) {
                h0 = 16;
            }
            SlotGeometry geo = SlotGeometry.get(slot, dlis.size(), this.width, this.height, this.imageHeight, this.imageWidth);
            if (!fluidStackDown.isEmpty()) {
                Screen.renderFluidStackInGUI(poseStack.last().pose(), fluidStackDown, 16, h0, geo.left(), geo.top());
            }
            if (!fluidStackDown.isEmpty()) {
                graphics.pose().pushPose();
                float scale_x = 0.6f;
                float scale_y = 0.6f;
                graphics.pose().scale(scale_x, scale_y, 1.0f);
                double roundedAmount = Math.floor((float)(amount * 10) / 1000.0f) / 10.0;
                Object amountLabel = String.format("%.1f", roundedAmount) + "B";
                if (((ContainerFluiDrawer)this.menu).getTileEntityFluidDrawer().upgrades().hasVendingUpgrade()) {
                    amount = Integer.MAX_VALUE;
                }
                if (amount >= 10000) {
                    amountLabel = (int)Math.floor((float)amount / 1000.0f) + "B";
                }
                if (amount >= 1000000) {
                    amountLabel = String.valueOf((int)Math.floor((float)amount / 1000.0f / 1000.0f)) + "K";
                }
                if (amount >= 1000000000) {
                    amountLabel = String.valueOf((int)Math.floor((float)amount / 1000.0f / 1000.0f / 1000.0f)) + "M";
                }
                if (amount >= 1000000000) {
                    amountLabel = "\u221e";
                }
                int textWidth = this.font.width((String)amountLabel);
                int innerX = (int)((float)(geo.left() + 16) / scale_x - (float)textWidth + 1.0f);
                float f = (float)geo.top() / scale_y;
                Objects.requireNonNull(this.font);
                int innerY = (int)(f - 9.0f + 1.0f);
                int color = Color.YELLOW.hashCode();
                graphics.drawString(this.font, (String)amountLabel, (float)innerX + 0.8f * scale_x, (float)innerY + 0.8f * scale_y, Color.DARK_GRAY.hashCode(), false);
                graphics.drawString(this.font, (String)amountLabel, innerX, innerY, color, false);
                graphics.pose().popPose();
            }
            if (!this.isInside(mouseX, mouseY, 17, 17, geo.left(), geo.top())) continue;
            graphics.fill(geo.left(), geo.top() - 16, geo.left() + 16, geo.top(), 0, -1996488705);
        }
        poseStack.popPose();
    }

    protected boolean isInside(int x, int y, int w, int h, double originX, double originY) {
        if ((double)(x - w) < originX && originX < (double)x) {
            return (double)y < originY && originY < (double)(y + h);
        }
        return false;
    }

    protected boolean isHovering(int x, int y, int width, int height, double originX, double originY) {
        return super.isHovering(x, y, width, height, originX, originY);
    }

    public static ResourceLocation getBgByType(IFluidDrawerGroup group) {
        int s = group.getDrawerCount();
        if (s == 4) {
            return StorageDrawers.rl((String)"textures/gui/drawers_4.png");
        }
        if (s == 2) {
            return StorageDrawers.rl((String)"textures/gui/drawers_2.png");
        }
        return StorageDrawers.rl((String)"textures/gui/drawers_1.png");
    }

    public record SlotGeometry(int left, int top, int w, int h) {
        public static SlotGeometry get(int slot, int count, int width, int height, int imageHeight, int imageWidth) {
            int guiX = (width - imageWidth) / 2;
            int guiY = (height - imageHeight) / 2;
            if (count == 4) {
                int orderY = 0;
                int orderX = 0;
                switch (slot) {
                    case 1: {
                        orderX = 1;
                        orderY = 1;
                        break;
                    }
                    case 2: {
                        orderX = 2;
                        orderY = 1;
                        break;
                    }
                    case 3: {
                        orderX = 1;
                        orderY = 2;
                        break;
                    }
                    case 4: {
                        orderX = 2;
                        orderY = 2;
                    }
                }
                int left = guiX + 93 + (orderX - 2) * 26;
                int top = guiY + 39 + (orderY - 1) * 26;
                return new SlotGeometry(left, top, 16, 16);
            }
            if (count == 2) {
                int orderY = slot == 1 ? 1 : 2;
                return new SlotGeometry(guiX + 80, guiY + 39 + (orderY - 1) * 26, 16, 16);
            }
            return new SlotGeometry(guiX + 80, guiY + 52, 16, 16);
        }
    }

    public static class Slot1
    extends Screen {
        public Slot1(ContainerFluiDrawer container, Inventory playerInv, Component name) {
            super(container, playerInv, name, Slot1.getBgByType(container.getTileEntityFluidDrawer()));
        }
    }
}

