/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client.gui;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.custom.InventoryUpgrade;

public class ContainerFluiDrawer
extends AbstractContainerMenu {
    private static final int[][] slotCoordinates = new int[][]{{80, 36}};
    private Container upgradeInventory;
    private List<Slot> upgradeSlots;
    private List<Slot> playerSlots;
    private List<Slot> hotbarSlots;
    private boolean isRemote;
    private BlockEntityFluidDrawer blockEntityFluidDrawer;

    public ContainerFluiDrawer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(ModContents.containerType.get(), windowId, playerInv, ContainerFluiDrawer.getTileEntity(playerInv, data.readBlockPos()));
    }

    public static BlockEntityFluidDrawer getTileEntity(Inventory playerInv, BlockPos pos) {
        BlockEntity blockEntity = playerInv.player.getCommandSenderWorld().getBlockEntity(pos);
        if (!(blockEntity instanceof BlockEntityFluidDrawer)) {
            StorageDrawers.log.error("Expected a drawers tile entity at " + pos.toString());
            return null;
        }
        BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)blockEntity;
        return tile;
    }

    public BlockEntityFluidDrawer getTileEntityFluidDrawer() {
        return this.blockEntityFluidDrawer;
    }

    public ContainerFluiDrawer(@Nullable MenuType<?> type, int windowId, Inventory playerInventory, BlockEntityFluidDrawer tileEntity) {
        super(type, windowId);
        int i;
        this.blockEntityFluidDrawer = tileEntity;
        boolean drawerCount = true;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        this.upgradeSlots = new ArrayList<Slot>();
        for (i = 0; i < 7; ++i) {
            this.upgradeSlots.add(this.addSlot((Slot)new SlotUpgrade(this.upgradeInventory, i, 26 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<Slot>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<Slot>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = playerInventory.player.getCommandSenderWorld().isClientSide();
    }

    protected int getStorageSlotX(int slot) {
        return slotCoordinates[slot][0];
    }

    protected int getStorageSlotY(int slot) {
        return slotCoordinates[slot][1];
    }

    public List<Slot> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slotIndex) {
        try {
            ItemStack itemStack = ItemStack.EMPTY;
            Slot slot = (Slot)this.slots.get(slotIndex);
            int upgradeStart = this.upgradeSlots.get((int)0).index;
            int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).index + 1;
            int inventoryStart = this.playerSlots.get((int)0).index;
            int hotbarStart = this.hotbarSlots.get((int)0).index;
            int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).index + 1;
            if (slot != null && slot.hasItem()) {
                ItemStack slotStack = slot.getItem();
                itemStack = slotStack.copy();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, true)) {
                        return ItemStack.EMPTY;
                    }
                    slot.onQuickCraft(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.isEmpty()) {
                    if (slotStack.getItem() instanceof ItemUpgrade) {
                        ItemStack slotStack1 = slotStack.copy();
                        slotStack1.setCount(1);
                        if (this.moveItemStackTo(slotStack1, upgradeStart, upgradeEnd, false)) {
                            slotStack.shrink(1);
                            if (slotStack.getCount() == 0) {
                                slot.set(ItemStack.EMPTY);
                            } else {
                                slot.setChanged();
                            }
                            slot.onTake(player, slotStack);
                            return ItemStack.EMPTY;
                        }
                        if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.moveItemStackTo(slotStack, inventoryStart, hotbarStart, false)) {
                            return ItemStack.EMPTY;
                        }
                    } else if (slotIndex >= inventoryStart && slotIndex < hotbarStart ? !this.moveItemStackTo(slotStack, hotbarStart, hotbarEnd, false) : slotIndex >= hotbarStart && slotIndex < hotbarEnd && !this.moveItemStackTo(slotStack, inventoryStart, hotbarStart, false)) {
                        return ItemStack.EMPTY;
                    }
                } else if (!this.moveItemStackTo(slotStack, inventoryStart, hotbarEnd, false)) {
                    return ItemStack.EMPTY;
                }
                int slotStackSize = slotStack.getCount();
                if (slotStackSize == 0) {
                    slot.set(ItemStack.EMPTY);
                } else {
                    slot.setChanged();
                }
                if (slotStackSize == itemStack.getCount()) {
                    return ItemStack.EMPTY;
                }
                slot.onTake(player, slotStack);
            }
            return itemStack;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ItemStack.EMPTY;
        }
    }

    public boolean stillValid(Player player) {
        return this.upgradeInventory.stillValid(player);
    }
}

