/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.client.gui.Screen;
import xueluoanping.fluiddrawerslegacy.client.model.BakedModelFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.render.FluidDrawerItemStackTileEntityRenderer;
import xueluoanping.fluiddrawerslegacy.client.render.TESRFluidDrawer;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetup {
    public static boolean isGlassLanternValidLayer(RenderType layerToCheck) {
        return layerToCheck == RenderType.cutoutMipped() || layerToCheck == RenderType.translucent();
    }

    @SubscribeEvent
    public static void onClientEvent(RegisterClientExtensionsEvent event) {
        for (DeferredHolder entry : ModContents.DREntityBlockItems.getEntries()) {
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return new FluidDrawerItemStackTileEntityRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
                }
            }, new Item[]{((Item)entry.value()).asItem()});
        }
    }

    @SubscribeEvent
    public static void onClientEvent(FMLClientSetupEvent event) {
        FluidDrawersLegacyMod.logger("Register Client");
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        ModContents.DRBlockEntities.getEntries().forEach(reg -> event.registerBlockEntityRenderer((BlockEntityType)reg.get(), TESRFluidDrawer::new));
    }

    @SubscribeEvent
    public static void onModelBaked(RegisterMenuScreensEvent event) {
        event.register(ModContents.containerType.get(), Screen.Slot1::new);
    }

    @SubscribeEvent
    public static void onModelBaked(ModelEvent.ModifyBakingResult event) {
        Map modelRegistry = event.getModels();
        ModContents.DREntityBlockItems.getEntries().forEach(reg -> {
            ModelResourceLocation location = new ModelResourceLocation(reg.getId(), "inventory");
            BakedModel existingModel = (BakedModel)modelRegistry.get(location);
            if (existingModel == null) {
                throw new RuntimeException("Did not find in registry");
            }
            if (existingModel instanceof BakedModelFluidDrawer) {
                throw new RuntimeException("Tried to replace twice");
            }
            BakedModelFluidDrawer model = new BakedModelFluidDrawer(existingModel);
            modelRegistry.put(location, model);
        });
    }
}

