/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.capability;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidDrawerControllerSave
extends SavedData {
    private final Map<BlockPos, FluidStack> chunkPosData = new HashMap<BlockPos, FluidStack>();

    public FluidDrawerControllerSave() {
    }

    public FluidDrawerControllerSave(HolderLookup.Provider provider, CompoundTag tag) {
        ListTag list = tag.getList("fluid", 10);
        for (Tag t : list) {
            CompoundTag manaTag = (CompoundTag)t;
            BlockPos chunkPos = new BlockPos(manaTag.getInt("x"), manaTag.getInt("y"), manaTag.getInt("z"));
            this.chunkPosData.put(chunkPos, FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)manaTag));
        }
    }

    public void update(BlockPos blockPos, FluidStack fluid) {
        this.chunkPosData.put(blockPos, fluid);
        this.setDirty();
    }

    public FluidStack get(BlockPos blockPos) {
        return this.chunkPosData.getOrDefault(blockPos, FluidStack.EMPTY);
    }

    public void remove(BlockPos blockPos) {
        this.chunkPosData.remove(blockPos);
        this.setDirty();
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider pRegistries) {
        ListTag list = new ListTag();
        this.chunkPosData.forEach((chunkPos, fluidStack) -> {
            CompoundTag fluidPosTag = new CompoundTag();
            fluidPosTag.putInt("x", chunkPos.getX());
            fluidPosTag.putInt("y", chunkPos.getY());
            fluidPosTag.putInt("z", chunkPos.getZ());
            fluidStack.save(pRegistries, (Tag)fluidPosTag);
            list.add((Object)fluidPosTag);
        });
        tag.put("fluid", (Tag)list);
        return tag;
    }

    public static FluidDrawerControllerSave get(ServerLevel serverLevel) {
        DimensionDataStorage storage = serverLevel.getDataStorage();
        return (FluidDrawerControllerSave)storage.computeIfAbsent(new SavedData.Factory(() -> FluidDrawerControllerSave.create(serverLevel), (compoundTag, provider) -> FluidDrawerControllerSave.load(serverLevel, compoundTag, provider)), "fluiddrawerslegacy");
    }

    private static FluidDrawerControllerSave load(ServerLevel serverLevel, CompoundTag compoundTag, HolderLookup.Provider provider) {
        return new FluidDrawerControllerSave((HolderLookup.Provider)serverLevel.registryAccess(), compoundTag);
    }

    private static FluidDrawerControllerSave create(ServerLevel serverLevel) {
        return new FluidDrawerControllerSave();
    }
}

