/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block.blockentity;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IDrawerCapabilityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.capabilities.BasicDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeStorage;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.api.drawer.BetterFluidManager;
import xueluoanping.fluiddrawerslegacy.api.drawer.IFluidDrawer;
import xueluoanping.fluiddrawerslegacy.api.drawer.IFluidDrawerGroup;
import xueluoanping.fluiddrawerslegacy.client.render.FluidAnimation;
import xueluoanping.fluiddrawerslegacy.config.General;
import xueluoanping.fluiddrawerslegacy.util.RegisterFinderUtil;

public class BlockEntityFluidDrawer
extends BaseBlockEntity
implements IFluidDrawerGroup,
IDrawerCapabilityProvider,
INetworked {
    private final BasicDrawerAttributes drawerAttributes = new DrawerAttributes();
    private final FluidGroupData fluidGroupData;
    private final UpgradeData upgradeData = new DrawerUpgradeData();
    private final ControllerData controllerData = new ControllerData();
    public FluidAnimation fluidAnimation = new FluidAnimation();

    public BlockEntityFluidDrawer(int slotCount, BlockPos pos, BlockState state) {
        super((BlockEntityType)ModContents.DRBlockEntities.getEntries().stream().filter(blockEntityTypeRegistryObject -> blockEntityTypeRegistryObject.getId().equals((Object)RegisterFinderUtil.getBlockKey(state.getBlock()))).findFirst().get().get(), pos, state);
        this.fluidGroupData = new FluidGroupData(slotCount, this);
        this.injectPortableData(this.fluidGroupData);
        this.upgradeData.setDrawerAttributes((IDrawerAttributesModifiable)this.drawerAttributes);
        this.injectPortableData((BlockEntityDataShim)this.upgradeData);
        this.injectPortableData((BlockEntityDataShim)this.controllerData);
    }

    private void checkBoundController() {
        Item item;
        BlockEntityController controller = this.controllerData.getController((BlockEntity)this);
        ItemStack remote = this.upgradeData.getRemoteUpgrade();
        if (remote == null && controller != null) {
            controller.invalidateRemoteNode((INetworked)this);
            this.controllerData.bind(null);
            return;
        }
        if (remote != null && (item = remote.getItem()) instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote itemRemote = (ItemUpgradeRemote)item;
            BlockEntityController upgradeController = ItemUpgradeRemote.getBoundController((ItemStack)remote, (LevelAccessor)this.level);
            if (controller != null && controller != upgradeController) {
                controller.invalidateRemoteNode((INetworked)this);
            }
            if (upgradeController != null) {
                this.controllerData.bind(upgradeController);
                if (!upgradeController.addRemoteNode((INetworked)this)) {
                    this.controllerData.bind(null);
                }
            }
            if (itemRemote.isBound() && this.controllerData.getController((BlockEntity)this) == null) {
                this.upgradeData.unbindRemoteUpgrade();
            }
        }
    }

    public boolean supportsDirectControllerLink() {
        return true;
    }

    public IControlGroup getBoundControlGroup() {
        return this.controllerData.getController((BlockEntity)this);
    }

    public boolean canRecurseSearch() {
        ItemStack upgrade = this.upgradeData.getRemoteUpgrade();
        if (upgrade == null) {
            return true;
        }
        Item item = upgrade.getItem();
        if (item instanceof ItemUpgradeRemote) {
            ItemUpgradeRemote item2 = (ItemUpgradeRemote)item;
            return item2.isGroupUpgrade();
        }
        return true;
    }

    public void unbindControlGroup() {
        this.upgradeData.unbindRemoteUpgrade();
    }

    public IDrawerGroup getGroup() {
        return this.fluidGroupData;
    }

    protected void onAttributeChanged() {
        this.requestModelDataUpdate();
    }

    public void inventoryChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public int getDrawerCount() {
        return this.fluidGroupData.getDrawerCount();
    }

    @NotNull
    public IFluidDrawer getDrawer(int i) {
        return this.fluidGroupData.getDrawer(i);
    }

    public int @NotNull [] getAccessibleDrawerSlots() {
        return new int[0];
    }

    public <T> T getCapability(@NotNull BlockCapability<T, Void> capability) {
        return (T)(this.level == null ? null : this.level.getCapability(capability, this.getBlockPos(), this.getBlockState(), (BlockEntity)this, null));
    }

    public CompoundTag writePortable(HolderLookup.Provider provider, CompoundTag tag) {
        tag = super.writePortable(provider, tag);
        EnumSet<LockAttribute> attrs = EnumSet.noneOf(LockAttribute.class);
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_EMPTY)) {
            attrs.add(LockAttribute.LOCK_EMPTY);
        }
        if (this.drawerAttributes.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attrs.add(LockAttribute.LOCK_POPULATED);
        }
        if (!attrs.isEmpty()) {
            tag.putByte("Lock", (byte)LockAttribute.getBitfield(attrs));
        }
        if (this.drawerAttributes.isConcealed()) {
            tag.putBoolean("Shr", true);
        }
        if (this.drawerAttributes.isShowingQuantity()) {
            tag.putBoolean("Qua", true);
        }
        return tag;
    }

    public void readPortable(HolderLookup.Provider provider, CompoundTag nbt) {
        super.readPortable(provider, nbt);
        if (nbt.contains("Lock")) {
            EnumSet attrs = LockAttribute.getEnumSet((int)nbt.getByte("Lock"));
            if (attrs != null) {
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, attrs.contains(LockAttribute.LOCK_EMPTY));
                this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, attrs.contains(LockAttribute.LOCK_POPULATED));
            }
        } else {
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_EMPTY, false);
            this.drawerAttributes.setItemLocked(LockAttribute.LOCK_POPULATED, false);
        }
        if (nbt.contains("Shr")) {
            this.drawerAttributes.setIsConcealed(nbt.getBoolean("Shr"));
        } else {
            this.drawerAttributes.setIsConcealed(false);
        }
        if (nbt.contains("Qua")) {
            this.drawerAttributes.setIsShowingQuantity(nbt.getBoolean("Qua"));
        } else {
            this.drawerAttributes.setIsShowingQuantity(false);
        }
    }

    public IDrawerAttributes getDrawerAttributes() {
        return this.drawerAttributes;
    }

    public <T> T getCapability(ChameleonCapability<T> capability) {
        return (T)(capability != null && this.level != null ? capability.getCapability(this.level, this.getBlockPos()) : null);
    }

    public BetterFluidManager<BlockEntityFluidDrawer> getTank() {
        return this.fluidGroupData.tank;
    }

    private static int getVolume() {
        return (Integer)General.volume.get();
    }

    private int getCapacityStandard() {
        return (int)((double)((Integer)General.volume.get()).intValue() * (this.isHalf() ? 0.5 : 1.0));
    }

    public int getCapacityEffective() {
        if (this.upgrades().hasVendingUpgrade() || this.upgrades().hasUnlimitedUpgrade()) {
            return Integer.MAX_VALUE;
        }
        if (this.upgrades().hasOneStackUpgrade()) {
            return 1000;
        }
        return this.getCapacityStandard() * this.upgrades().getStorageMultiplier();
    }

    public int getCapacityTankEffective() {
        return this.getCapacityEffective() / this.getDrawerCount();
    }

    public int getCapacityTankStandard() {
        return this.getCapacityStandard() / this.getDrawerCount();
    }

    public int getCapacityUsed() {
        int used = 0;
        for (FluidDrawerData data : this.fluidGroupData.slots) {
            used += data.getTank().getFluidAmount();
        }
        return used;
    }

    public static int calculateTankCapacityFromStack(HolderLookup.Provider provider, ItemStack stack) {
        int tankCapacity = BlockEntityFluidDrawer.getVolume();
        CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (tag != null) {
            int size;
            if (tag.contains("tanks") && (size = tag.getList("tanks", 10).size()) > 0) {
                tankCapacity /= size;
            }
            UpgradeData up = new UpgradeData(7);
            up.read(provider, tag);
            int mul = up.getStorageMultiplier();
            tankCapacity *= mul;
            if (stack.getItem().getDescriptionId().contains("half")) {
                tankCapacity /= 2;
            }
            if (up.hasVendingUpgrade() || up.hasUnlimitedUpgrade()) {
                tankCapacity = Integer.MAX_VALUE;
            }
            if (up.hasOneStackUpgrade()) {
                tankCapacity = 1000;
            }
        }
        return tankCapacity;
    }

    public int getRedstoneLevel() {
        return (int)((float)this.getCapacityUsed() / (float)this.getCapacityEffective() * 15.0f);
    }

    public boolean isRedstone() {
        return this.upgrades().getRedstoneType() != null;
    }

    public UpgradeData upgrades() {
        return this.upgradeData;
    }

    public boolean isHalf() {
        return this.getBlockState().getBlock().getDescriptionId().contains("half");
    }

    private class DrawerAttributes
    extends BasicDrawerAttributes {
        private DrawerAttributes() {
        }

        protected void onAttributeChanged() {
            BlockEntityFluidDrawer.this.onAttributeChanged();
            if (BlockEntityFluidDrawer.this.getLevel() != null && !BlockEntityFluidDrawer.this.getLevel().isClientSide) {
                BlockEntityFluidDrawer.this.setChanged();
                BlockEntityFluidDrawer.this.markBlockForUpdate();
            }
        }

        public boolean isUnlimitedVending() {
            return BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade();
        }

        public boolean setItemLocked(LockAttribute attr, boolean isLocked) {
            boolean result = super.setItemLocked(attr, isLocked);
            return result;
        }
    }

    private class DrawerUpgradeData
    extends UpgradeData {
        DrawerUpgradeData() {
            super(7);
        }

        public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
            if (!super.canAddUpgrade(upgrade)) {
                return false;
            }
            if (upgrade.getItem() == ModItems.FILL_LEVEL_UPGRADE.get()) {
                return false;
            }
            if (upgrade.getItem() == ModItems.ONE_STACK_UPGRADE.get()) {
                if (BlockEntityFluidDrawer.this.upgrades().hasOneStackUpgrade()) {
                    return false;
                }
                for (int i = 0; i < BlockEntityFluidDrawer.this.getDrawerCount(); ++i) {
                    Object tank = BlockEntityFluidDrawer.this.getDrawer(i).getTank();
                    if (tank.getFluidAmount() < tank.getCapacity() / 32) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean canRemoveUpgrade(int slot) {
            if (!super.canRemoveUpgrade(slot)) {
                return false;
            }
            ItemStack upgrade = this.getUpgrade(slot);
            if (upgrade.getItem() instanceof ItemUpgradeStorage) {
                int storageLevel = ((ItemUpgradeStorage)upgrade.getItem()).level.getLevel();
                int storageMult = ModCommonConfig.INSTANCE.UPGRADES.getLevelMult(storageLevel);
                int effectiveStorageMult = BlockEntityFluidDrawer.this.upgrades().getStorageMultiplier();
                if (effectiveStorageMult == storageMult) {
                    --storageMult;
                }
                for (int i = 0; i < BlockEntityFluidDrawer.this.getDrawerCount(); ++i) {
                    int amount = BlockEntityFluidDrawer.this.getDrawer(i).getTank().getFluidAmount();
                    int standardCapacity = BlockEntityFluidDrawer.this.getCapacityTankStandard();
                    int afterCapacity = standardCapacity * (effectiveStorageMult - storageMult);
                    if (afterCapacity >= amount) continue;
                    return false;
                }
            }
            return true;
        }

        protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
            if (BlockEntityFluidDrawer.this.getLevel() != null && !BlockEntityFluidDrawer.this.getLevel().isClientSide) {
                BlockEntityFluidDrawer.this.checkBoundController();
                if (BlockEntityFluidDrawer.this.getBoundControlGroup() != null) {
                    BlockEntityFluidDrawer.this.getBoundControlGroup().addRemoteNode((INetworked)BlockEntityFluidDrawer.this);
                }
                BlockEntityFluidDrawer.this.setChanged();
                BlockEntityFluidDrawer.this.markBlockForUpdate();
            }
        }
    }

    public class FluidGroupData
    extends BlockEntityDataShim
    implements IFluidDrawerGroup,
    IDrawerCapabilityProvider {
        public final BetterFluidManager<BlockEntityFluidDrawer> tank;
        private final FluidDrawerData[] slots;

        public FluidGroupData(int slotCount, BlockEntityFluidDrawer blockEntityFluidDrawer) {
            this.slots = new FluidDrawerData[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.slots[i] = this.createDrawer(i);
            }
            this.tank = this.createFuildHandler(blockEntityFluidDrawer);
        }

        private BetterFluidManager<BlockEntityFluidDrawer> createFuildHandler(BlockEntityFluidDrawer blockEntityFluidDrawer) {
            return new BetterFluidManager<BlockEntityFluidDrawer>(blockEntityFluidDrawer);
        }

        protected FluidDrawerData createDrawer(int slot) {
            return new FluidDrawerData(this, slot, BlockEntityFluidDrawer.this.getCapacityStandard() / this.slots.length);
        }

        public int getDrawerCount() {
            return this.slots.length;
        }

        @NotNull
        public IFluidDrawer getDrawer(int i) {
            return this.slots[i];
        }

        public int[] getAccessibleDrawerSlots() {
            return new int[0];
        }

        public boolean isGroupValid() {
            return !BlockEntityFluidDrawer.this.isRemoved();
        }

        public <T> T getCapability(ChameleonCapability<T> capability) {
            return (T)(capability != null && BlockEntityFluidDrawer.this.level != null ? capability.getCapability(BlockEntityFluidDrawer.this.level, BlockEntityFluidDrawer.this.getBlockPos()) : null);
        }

        public CompoundTag write(HolderLookup.Provider provider, CompoundTag tag) {
            BlockEntityFluidDrawer.this.upgradeData.write(provider, tag);
            ListTag tanklist = new ListTag();
            for (FluidDrawerData data : this.slots) {
                tanklist.add((Object)data.serializeNBT(provider));
            }
            tag.put("tanks", (Tag)tanklist);
            return tag;
        }

        public void read(HolderLookup.Provider provider, CompoundTag nbt) {
            BlockEntityFluidDrawer.this.upgrades().read(provider, nbt);
            if (nbt.contains("tank")) {
                this.slots[0].deserializeNBT(provider, nbt.getCompound("tank"));
            } else if (nbt.contains("tanks")) {
                ListTag tanklist = nbt.getList("tanks", 10);
                for (int i = 0; i < tanklist.size(); ++i) {
                    this.slots[i].deserializeNBT(provider, tanklist.getCompound(i));
                }
            }
        }

        public boolean idVoidUpgrade() {
            return BlockEntityFluidDrawer.this.getDrawerAttributes().isVoid();
        }
    }

    public class FluidDrawerData
    implements IFluidDrawer<betterFluidHandler>,
    INBTSerializable<CompoundTag> {
        private int slot;
        private final FluidGroupData group;
        private final betterFluidHandler tank;
        public FluidAnimation fluidAnimation = new FluidAnimation();

        public FluidDrawerData(FluidGroupData group, int slot, int ca) {
            this.group = group;
            this.slot = slot;
            this.tank = this.createFluidHandler(ca);
        }

        private betterFluidHandler createFluidHandler(int ca) {
            return new betterFluidHandler(ca);
        }

        public BlockPos getDrawerPos() {
            return BlockEntityFluidDrawer.this.getBlockPos();
        }

        @Override
        public betterFluidHandler getTank() {
            return this.tank;
        }

        @Override
        public FluidStack getCacheFluid() {
            return this.getTank().getCacheFluid();
        }

        @Override
        public FluidAnimation getFluidAnimation() {
            return this.fluidAnimation;
        }

        public boolean isLock() {
            return BlockEntityFluidDrawer.this.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY);
        }

        public boolean isVoid() {
            return BlockEntityFluidDrawer.this.upgrades().serializeNBT((HolderLookup.Provider)BlockEntityFluidDrawer.this.level.registryAccess()).toString().contains("void");
        }

        public int getMaxTankCapacity() {
            return BlockEntityFluidDrawer.this.getCapacityTankEffective();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            return this.tank.serializeNBT(provider);
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.tank.deserializeNBT(provider, nbt);
        }

        public IDrawer copy() {
            return new FluidDrawerData(this.group, this.slot, this.tank.getCapacity());
        }
    }

    public class betterFluidHandler
    extends FluidTank {
        private FluidStack cacheFluid;

        public FluidStack getCacheFluid() {
            return this.cacheFluid.copy();
        }

        private void setCacheFluid(FluidStack cacheFluid) {
            FluidStack cacheFluidCopy = cacheFluid.copy();
            if (!cacheFluidCopy.isEmpty()) {
                cacheFluidCopy.setAmount(1);
            }
            this.cacheFluid = cacheFluidCopy;
        }

        public betterFluidHandler(int capacity) {
            super(capacity);
            this.cacheFluid = FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack getFluid() {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade() && this.fluid.getFluid() != Fluids.EMPTY) {
                return new FluidStack(super.getFluid().getFluidHolder(), Integer.MAX_VALUE);
            }
            return super.getFluid();
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            if (this.getCapacity() != BlockEntityFluidDrawer.this.getCapacityTankEffective()) {
                this.setCapacity(BlockEntityFluidDrawer.this.getCapacityTankEffective());
            }
            CompoundTag nbt = new CompoundTag();
            if (this.getCacheFluid().getFluid() != Fluids.EMPTY && this.fluid.getFluid() != Fluids.EMPTY && this.getCacheFluid().getFluid() != this.fluid.getFluid()) {
                this.setCacheFluid(this.getFluid());
            }
            if (this.getCacheFluid().getFluid() == Fluids.EMPTY && this.getFluid().getAmount() > 0) {
                this.setCacheFluid(this.getFluid());
            }
            nbt.put("cache", this.cacheFluid.saveOptional(provider));
            return this.writeToNBT(provider, nbt);
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tank) {
            if (this.getCapacity() != BlockEntityFluidDrawer.this.getCapacityTankEffective()) {
                this.setCapacity(BlockEntityFluidDrawer.this.getCapacityTankEffective());
            }
            if (tank.contains("cache")) {
                FluidStack cacheTempStack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tank.getCompound("cache"));
                this.setCacheFluid(cacheTempStack);
            }
            this.readFromNBT(provider, tank);
        }

        protected void onContentsChanged() {
            BlockEntityFluidDrawer.this.inventoryChanged();
            super.onContentsChanged();
        }

        public boolean isFull() {
            return this.getFluidAmount() == this.getCapacity();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return 0;
            }
            if (BlockEntityFluidDrawer.this.getDrawerAttributes().isItemLocked(LockAttribute.LOCK_EMPTY)) {
                if (this.getCacheFluid().getFluid() != Fluids.EMPTY && !FluidStack.isSameFluid((FluidStack)this.getCacheFluid(), (FluidStack)resource)) {
                    return 0;
                }
                if (this.getCacheFluid().getFluid() == Fluids.EMPTY) {
                    if (resource.getAmount() > 0) {
                        if (action.execute()) {
                            this.setCacheFluid(resource);
                        }
                        return super.fill(resource, action);
                    }
                    return 0;
                }
            }
            if (this.getCapacity() - this.fluid.getAmount() - resource.getAmount() < 0 && BlockEntityFluidDrawer.this.upgrades().write((HolderLookup.Provider)BlockEntityFluidDrawer.this.level.registryAccess(), new CompoundTag()).toString().contains("storagedrawers:void_upgrade")) {
                if (resource.isEmpty() || !this.isFluidValid(resource)) {
                    return 0;
                }
                if (action.simulate()) {
                    return resource.getAmount();
                }
                if (this.fluid.isEmpty()) {
                    this.fluid = new FluidStack(resource.getFluidHolder(), Math.min(this.capacity, resource.getAmount()));
                    this.onContentsChanged();
                    return this.fluid.getAmount();
                }
                if (!FluidStack.isSameFluid((FluidStack)this.fluid, (FluidStack)resource)) {
                    return 0;
                }
                this.fluid.setAmount(this.capacity);
                this.onContentsChanged();
                return resource.getAmount();
            }
            return super.fill(resource, action);
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return resource.getFluid() == this.fluid.getFluid() ? new FluidStack(this.fluid.getFluid(), resource.getAmount()) : FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (BlockEntityFluidDrawer.this.upgrades().hasVendingUpgrade()) {
                return new FluidStack(this.fluid.getFluid(), maxDrain);
            }
            return super.drain(maxDrain, action);
        }
    }
}

