/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;
import xueluoanping.fluiddrawerslegacy.util.SafeClientAccess;
import xueluoanping.fluiddrawerslegacy.util.TooltipKey;

public class ItemFluidDrawer
extends BlockItem {
    public ItemFluidDrawer(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public Component getName(ItemStack stack) {
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> componentList, TooltipFlag flag) {
        TooltipKey key;
        super.appendHoverText(stack, pContext, componentList, flag);
        if (pContext.level() instanceof ClientLevel && ((key = SafeClientAccess.getTooltipKey()) == TooltipKey.SHIFT || key == TooltipKey.UNKNOWN)) {
            Byte b;
            EnumSet attrs;
            FluidStack fluidStack;
            boolean hasFluid = false;
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("tank")) {
                ListTag tanklist = new ListTag();
                tanklist.add((Object)tag.getCompound("tank"));
                tag.put("tanks", (Tag)tanklist);
            }
            if (tag.contains("tanks")) {
                int slotCouont = 0;
                for (Tag tank : tag.getList("tanks", 10)) {
                    ++slotCouont;
                    fluidStack = FluidStack.parseOptional((HolderLookup.Provider)pContext.registries(), (CompoundTag)((CompoundTag)tank).getCompound("Fluid"));
                    if (tag.toString().contains("storagedrawers:creative_vending_upgrade")) {
                        fluidStack.setAmount(Integer.MAX_VALUE);
                    }
                    if (fluidStack.getAmount() <= 0) continue;
                    hasFluid = true;
                    String str = I18n.get((String)"statement.fluiddrawerslegacy.fluiddrawer.slot", (Object[])new Object[]{slotCouont, fluidStack.getAmount(), fluidStack.getHoverName().getString()});
                    componentList.add((Component)Component.translatable((String)str));
                }
            }
            if (tag.contains("Lock") && (attrs = LockAttribute.getEnumSet((int)(b = Byte.valueOf(tag.getByte("Lock"))).byteValue())).contains(LockAttribute.LOCK_EMPTY)) {
                Object fluidNameShow = "";
                if (!hasFluid && tag.contains("tank") && tag.getCompound("tank").contains("cache")) {
                    fluidStack = FluidStack.parseOptional((HolderLookup.Provider)pContext.registries(), (CompoundTag)tag.getCompound("tank").getCompound("cache"));
                    fluidNameShow = fluidStack.getHoverName().getString() + " ";
                }
                componentList.add((Component)Component.translatable((String)(" \u00a77(" + (String)fluidNameShow + I18n.get((String)"tooltip.storagedrawers.waila.locked", (Object[])new Object[0]) + ") ")));
            }
        }
    }
}

