/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeRemote;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import xueluoanping.fluiddrawerslegacy.ModContents;
import xueluoanping.fluiddrawerslegacy.api.exchange.FluidExchangeHandlerManager;
import xueluoanping.fluiddrawerslegacy.block.blockentity.BlockEntityFluidDrawer;
import xueluoanping.fluiddrawerslegacy.client.gui.ContainerFluiDrawer;
import xueluoanping.fluiddrawerslegacy.config.General;
import xueluoanping.fluiddrawerslegacy.util.MathUtils;

public class BlockFluidDrawer
extends HorizontalDirectionalBlock
implements INetworked,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape shape;
    private static final VoxelShape shapef;
    public final Map<Direction, VoxelShape> getShape;
    private final int slotCount;
    private final boolean half;

    public BlockFluidDrawer(BlockBehaviour.Properties properties, int slotCount, boolean half) {
        super(properties);
        this.slotCount = slotCount;
        this.half = half;
        this.getShape = new HashMap<Direction, VoxelShape>(){
            {
                VoxelShape s = BlockFluidDrawer.this.isHalf() ? shapef : shape;
                this.put(Direction.EAST, MathUtils.getShapefromAngle(s, 270));
                this.put(Direction.SOUTH, MathUtils.getShapefromAngle(s, 180));
                this.put(Direction.WEST, MathUtils.getShapefromAngle(s, 90));
                this.put(Direction.NORTH, s);
            }
        };
    }

    private boolean isHalf() {
        return this.half;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        super.createBlockStateDefinition(p_49915_.add(new Property[]{FACING}));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape.get(state.getValue((Property)FACING));
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        Direction playerFrom = hit.getDirection();
        if (playerFrom == Direction.UP || playerFrom == Direction.DOWN) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (this.isHalf() && playerFrom != facing) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            final BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            ItemStack heldStack = player.getItemInHand(hand);
            ItemStack offhandStack = player.getOffhandItem();
            if (facing == playerFrom && heldStack.isEmpty() && player.isShiftKeyDown()) {
                if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.enableUI.get()).booleanValue() && !world.isClientSide()) {
                    ((ServerPlayer)player).openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return BlockFluidDrawer.this.getName();
                        }

                        @Nullable
                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInv, Player playerEntity) {
                            return new ContainerFluiDrawer(ModContents.containerType.get(), windowId, playerInv, tile);
                        }
                    }, extraData -> extraData.writeBlockPos(pos));
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (facing == playerFrom && heldStack.getItem() instanceof ItemUpgrade) {
                if (tile.upgrades().canAddUpgrade(heldStack)) {
                    Item item = heldStack.getItem();
                    if (item instanceof ItemUpgradeRemote) {
                        ItemUpgradeRemote remote = (ItemUpgradeRemote)item;
                        if (!tile.upgrades().hasRemoteUpgrade() && remote.isBound()) {
                            tile.upgrades().updateRemoteUpgradeBinding(heldStack);
                            BlockPos boundPosition = ItemUpgradeRemote.getBoundPosition((ItemStack)heldStack);
                            if (boundPosition != null) {
                                player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.updated_remote_binding", (Object[])new Object[]{boundPosition.getX(), boundPosition.getY(), boundPosition.getZ()}), true);
                            }
                        }
                    }
                    if (tile.upgrades().addUpgrade(heldStack)) {
                        if (!player.isCreative()) {
                            heldStack.shrink(1);
                        }
                        return ItemInteractionResult.SUCCESS;
                    }
                    if (!world.isClientSide()) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.max_upgrades"), true);
                    }
                } else if (!world.isClientSide()) {
                    player.displayClientMessage((Component)Component.translatable((String)"message.storagedrawers.cannot_add_upgrade"), true);
                }
            } else if (offhandStack == ItemStack.EMPTY && !player.isShiftKeyDown()) {
                IFluidHandler tank;
                Vec3 loc = hit.getLocation().add((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
                int tankSlot = BlockFluidDrawer.getSlotByVec(loc, facing, playerFrom, this.getSlotCount());
                IFluidHandler iFluidHandler = tank = tankSlot == -1 ? tile.getTank() : (IFluidHandler)tile.getDrawer(tankSlot).getTank();
                if (FluidExchangeHandlerManager.tryHandleByMod(tank, player, hand)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank)) {
                    return ItemInteractionResult.SUCCESS;
                }
                if (FluidExchangeHandlerManager.mayConsume(player, hand)) {
                    return ItemInteractionResult.CONSUME;
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static int getSlotByVec(Vec3 loc, Direction facing, Direction playerFrom, int slotCount) {
        int tankSlot = 0;
        if (slotCount == 2) {
            tankSlot = loc.y() > 0.5 ? 0 : 1;
        } else if (slotCount == 4) {
            int angle = (int)(facing.toYRot() - playerFrom.toYRot());
            if (angle == 0) {
                MathUtils.Point p = new MathUtils.Point(loc);
                switch (facing) {
                    case EAST: {
                        p = new MathUtils.Point(p.z, p.y, 0.0);
                        break;
                    }
                    case SOUTH: {
                        p = new MathUtils.Point(1.0 - p.x, p.y, 0.0);
                        break;
                    }
                    case WEST: {
                        p = new MathUtils.Point(1.0 - p.z, p.y, 0.0);
                    }
                }
                int xo = p.x < 0.5 ? 1 : 0;
                int yo = p.y < 0.5 ? 2 : 0;
                tankSlot = xo + yo;
            } else {
                tankSlot = angle == 90 || angle == -270 ? (loc.y() > 0.5 ? 1 : 3) : (loc.y() > 0.5 ? 0 : 2);
            }
        }
        tankSlot = tankSlot < 0 || tankSlot >= slotCount ? -1 : tankSlot;
        return tankSlot;
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = this.asItem().getDefaultInstance();
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            tile.writePortable((HolderLookup.Provider)level.registryAccess(), ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag());
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tile.writePortable((HolderLookup.Provider)level.registryAccess(), ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag())));
        }
        return stack;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)tileEntity;
            tile.readPortable((HolderLookup.Provider)level.registryAccess(), ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag());
        }
        super.setPlacedBy(level, pos, state, entity, stack);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player playerEntity) {
        BlockEntity blockEntity;
        state = super.playerWillDestroy(level, pos, state, playerEntity);
        if (level instanceof ServerLevel && !((Boolean)General.retainFluid.get()).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BlockEntityFluidDrawer) {
            BlockEntityFluidDrawer blockEntityFluidDrawer = (BlockEntityFluidDrawer)blockEntity;
            Optional.ofNullable((IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, null)).ifPresent(iFluidHandler -> {
                for (int i = 0; i < iFluidHandler.getTanks(); ++i) {
                    iFluidHandler.drain(iFluidHandler.getFluidInTank(i), IFluidHandler.FluidAction.EXECUTE);
                }
            });
        }
        return state;
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        super.destroy(level, pos, state);
        level.playSound(null, pos, Fluids.WATER.getFluidType().getSound(SoundActions.BUCKET_EMPTY), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!this.isSignalSource(state) || !(blockAccess.getBlockEntity(pos) instanceof BlockEntityFluidDrawer)) {
            return 0;
        }
        BlockEntityFluidDrawer tile = (BlockEntityFluidDrawer)blockAccess.getBlockEntity(pos);
        return tile != null && tile.isRedstone() ? tile.getRedstoneLevel() : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter worldIn, BlockPos pos, Direction side) {
        return side == Direction.UP ? this.getSignal(state, worldIn, pos, side) : 0;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityFluidDrawer(this.getSlotCount(), pos, state);
    }

    private int getSlotCount() {
        return this.slotCount;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    static {
        VoxelShape base = Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape column1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0);
        VoxelShape column2 = column1.move(0.9375, 0.0, 0.0);
        VoxelShape column3 = Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)1.0);
        VoxelShape column4 = column3.move(0.0, 0.9375, 0.0);
        VoxelShape column = Shapes.or((VoxelShape)column1, (VoxelShape[])new VoxelShape[]{column2, column3, column4});
        shape = Shapes.or((VoxelShape)base, (VoxelShape)column);
        VoxelShape basef = Block.box((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        shapef = Shapes.or((VoxelShape)basef, (VoxelShape)column.move(0.0, 0.0, 0.5));
    }
}

