/*
 * Decompiled with CFR 0.152.
 */
package xueluoanping.fluiddrawerslegacy.api.exchange;

import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.ModFileScanData;
import xueluoanping.fluiddrawerslegacy.FluidDrawersLegacyMod;
import xueluoanping.fluiddrawerslegacy.api.exchange.ExchangeHandlerAno;
import xueluoanping.fluiddrawerslegacy.api.exchange.ModExchangeHandler;
import xueluoanping.fluiddrawerslegacy.handler.FluidDrawerHandler;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class FluidExchangeHandlerManager {
    public static FluidItem FluidManager = new FluidItem();

    @SubscribeEvent
    public static void get(FMLLoadCompleteEvent event) {
        List<String> classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            if (!$.annotationType().getClassName().equals(ExchangeHandlerAno.class.getName())) {
                return false;
            }
            ArrayList required = $.annotationData().getOrDefault("mods", new ArrayList());
            return new HashSet<String>(ModList.get().getMods().stream().map(IModInfo::getModId).toList()).containsAll(required);
        }).map(ModFileScanData.AnnotationData::memberName).toList();
        for (String className : classNames) {
            FluidDrawersLegacyMod.logger("Start loading modHandler at " + className);
            try {
                Class<?> clazz = Class.forName(className);
                if (!ModExchangeHandler.class.isAssignableFrom(clazz)) continue;
                ModExchangeHandler plugin = (ModExchangeHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.registerFluidItem(FluidManager);
            }
            catch (Throwable var7) {
                FluidDrawersLegacyMod.logger("Error loading modHandler at " + className, var7);
            }
        }
    }

    public static boolean tryHandleByMod(IFluidHandler tile, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        try {
            for (FluidItemHolder fluidItemHolder : FluidExchangeHandlerManager.FluidManager.handlers) {
                ItemStack itemStack;
                FluidStack fluidStack = fluidItemHolder.getFluidByItem.apply(heldStack);
                if (fluidStack.isEmpty() || (itemStack = fluidItemHolder.getItemByFluid.apply(fluidStack)).isEmpty() || !FluidDrawerHandler.rightClickInPut(tile, player, fluidStack, itemStack, hand)) continue;
                return true;
            }
            for (FluidContainerHolder fluidContainerHolder : FluidExchangeHandlerManager.FluidManager.outHandlers) {
                if (!fluidContainerHolder.applyItem.test(heldStack) || !FluidDrawerHandler.rightClickOuput(tile, player, fluidContainerHolder.checkFluidAmount, fluidContainerHolder.getItemByFluid, heldStack, hand)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean mayConsume(Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        try {
            for (FluidItemHolder fluidItemHolder : FluidExchangeHandlerManager.FluidManager.handlers) {
                FluidStack fluidStack = fluidItemHolder.getFluidByItem.apply(heldStack);
                if (fluidStack.isEmpty()) continue;
                return true;
            }
            for (FluidContainerHolder fluidContainerHolder : FluidExchangeHandlerManager.FluidManager.outHandlers) {
                if (!fluidContainerHolder.applyItem.test(heldStack)) continue;
                return true;
            }
            if (heldStack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ArrayList<FluidStack> getFluidInItemContainer(ItemStack heldStack) {
        ArrayList<FluidStack> fluidStacksList = new ArrayList<FluidStack>();
        try {
            for (FluidItemHolder handler : FluidExchangeHandlerManager.FluidManager.handlers) {
                FluidStack fluidStack = handler.getFluidByItem.apply(heldStack);
                if (fluidStack.isEmpty()) continue;
                fluidStacksList.add(fluidStack);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (heldStack.getCapability(Capabilities.FluidHandler.ITEM) != null) {
            Optional.ofNullable((IFluidHandlerItem)heldStack.getCapability(Capabilities.FluidHandler.ITEM)).ifPresent(itemFluidHandler -> {
                int size = itemFluidHandler.getTanks();
                for (int i = 0; i < size; ++i) {
                    if (itemFluidHandler.getFluidInTank(i).isEmpty()) continue;
                    fluidStacksList.add(itemFluidHandler.getFluidInTank(i));
                }
            });
        }
        return fluidStacksList;
    }

    public static boolean tryHandleClickInputByMod(BlockEntityController tile, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), null) != null) {
            try {
                IFluidHandler fluidM = (IFluidHandler)tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, tile.getBlockPos(), null);
                for (FluidItemHolder handler : FluidExchangeHandlerManager.FluidManager.handlers) {
                    ItemStack itemStack;
                    FluidStack fluidStack = handler.getFluidByItem.apply(heldStack);
                    if (fluidStack.isEmpty() || (itemStack = handler.getItemByFluid.apply(fluidStack)).isEmpty() || !FluidDrawerHandler.rightClickInPut(fluidM, player, fluidStack, itemStack, hand)) continue;
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static class FluidItem {
        public List<FluidItemHolder> handlers = new ArrayList<FluidItemHolder>();
        public List<FluidContainerHolder> outHandlers = new ArrayList<FluidContainerHolder>();

        public void registerFluidItem(Function<ItemStack, FluidStack> getFluidByItem, Function<FluidStack, ItemStack> getItemByFluid) {
            this.handlers.add(new FluidItemHolder(getFluidByItem, getItemByFluid));
        }

        public void registerFluidContainer(Predicate<ItemStack> applyItem, Function<FluidStack, Integer> checkFluidAmount, Function<FluidStack, ItemStack> getItemByFluid) {
            this.outHandlers.add(new FluidContainerHolder(applyItem, checkFluidAmount, getItemByFluid));
        }
    }

    public record FluidItemHolder(Function<ItemStack, FluidStack> getFluidByItem, Function<FluidStack, ItemStack> getItemByFluid) {
    }

    public record FluidContainerHolder(Predicate<ItemStack> applyItem, Function<FluidStack, Integer> checkFluidAmount, Function<FluidStack, ItemStack> getItemByFluid) {
    }
}

