/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.iface;

import com.refinedmods.refinedstorage.api.network.impl.node.iface.InterfaceExportState;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.iface.InterfaceBlockEntity;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class ExportedResourcesContainer
extends ResourceContainerImpl
implements InterfaceExportState {
    private final FilterWithFuzzyMode filter;

    ExportedResourcesContainer(int size, FilterWithFuzzyMode filter) {
        super(size, InterfaceBlockEntity::getTransferQuota, RefinedStorageApi.INSTANCE.getItemResourceFactory(), RefinedStorageApi.INSTANCE.getAlternativeResourceFactories());
        this.filter = filter;
    }

    @Override
    public int getSlots() {
        return this.size();
    }

    @Override
    public Collection<ResourceKey> expandExportCandidates(RootStorage rootStorage, ResourceKey resource) {
        if (!this.filter.isFuzzyMode()) {
            return Collections.singletonList(resource);
        }
        if (!(rootStorage instanceof FuzzyRootStorage)) {
            return Collections.singletonList(resource);
        }
        FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
        return fuzzyRootStorage.getFuzzy(resource);
    }

    @Override
    public boolean isExportedResourceValid(ResourceKey want, ResourceKey got) {
        if (!this.filter.isFuzzyMode()) {
            return got.equals(want);
        }
        ResourceKey normalizedGot = this.normalize(got);
        ResourceKey normalizedWant = this.normalize(want);
        return normalizedGot.equals(normalizedWant);
    }

    private ResourceKey normalize(ResourceKey resource) {
        if (resource instanceof FuzzyModeNormalizer) {
            FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)resource);
            return normalizer.normalize();
        }
        return resource;
    }

    @Override
    @Nullable
    public ResourceKey getRequestedResource(int slotIndex) {
        return this.filter.getFilterContainer().getResource(slotIndex);
    }

    @Override
    public long getRequestedAmount(int slotIndex) {
        return this.filter.getFilterContainer().getAmount(slotIndex);
    }

    @Override
    @Nullable
    public ResourceKey getExportedResource(int slotIndex) {
        return this.getResource(slotIndex);
    }

    @Override
    public long getExportedAmount(int slotIndex) {
        return this.getAmount(slotIndex);
    }

    @Override
    public void setExportSlot(int slotIndex, ResourceKey resource, long amount) {
        this.set(slotIndex, new ResourceAmount(resource, amount));
    }

    @Override
    public void shrinkExportedAmount(int slotIndex, long amount) {
        this.shrink(slotIndex, amount);
    }

    @Override
    public void growExportedAmount(int slotIndex, long amount) {
        this.grow(slotIndex, amount);
    }
}

