/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.api.autocrafting.preview;

import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewType;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreviewNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MutableTreePreviewNode {
    private final ResourceKey resource;
    private final Map<ResourceKey, MutableTreePreviewNode> children = new LinkedHashMap<ResourceKey, MutableTreePreviewNode>();
    private long amount;
    private long toCraft;
    private long available;
    private long missing;

    MutableTreePreviewNode(ResourceKey resource) {
        this.resource = resource;
    }

    void available(long amt) {
        this.available += amt;
    }

    void toCraft(long amt) {
        this.toCraft += amt;
    }

    void missing(long amt) {
        this.missing += amt;
    }

    void add(long amt) {
        this.amount += amt;
    }

    MutableTreePreviewNode add(ResourceKey childResource) {
        return this.add(childResource, 0L);
    }

    MutableTreePreviewNode add(ResourceKey childResource, long childAmount) {
        MutableTreePreviewNode existing = this.children.get(childResource);
        if (existing != null) {
            existing.add(childAmount);
            return existing;
        }
        MutableTreePreviewNode child = new MutableTreePreviewNode(childResource);
        child.add(childAmount);
        this.children.put(childResource, child);
        return child;
    }

    void merge(MutableTreePreviewNode node) {
        MutableTreePreviewNode merged = this.add(node.resource, node.amount);
        merged.available(node.available);
        merged.toCraft(node.toCraft);
        merged.missing(node.missing);
        node.children.values().forEach(merged::merge);
    }

    private boolean hasMissing() {
        return this.missing > 0L || this.children.values().stream().anyMatch(MutableTreePreviewNode::hasMissing);
    }

    private PreviewType getType() {
        if (this.hasMissing()) {
            return PreviewType.MISSING_RESOURCES;
        }
        return PreviewType.SUCCESS;
    }

    TreePreview asRootInPreview() {
        return new TreePreview(this.getType(), this.build(), Collections.emptyList());
    }

    TreePreviewNode build() {
        return new TreePreviewNode(this.resource, this.amount, this.toCraft, this.available, this.missing, this.children.values().stream().map(MutableTreePreviewNode::build).toList());
    }

    public String toString() {
        return "MutableTreePreviewNode{resource=" + String.valueOf(this.resource) + ", amount=" + this.amount + ", toCraft=" + this.toCraft + ", available=" + this.available + ", missing=" + this.missing + ", children=" + String.valueOf(this.children.values()) + "}";
    }
}

