/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.ability.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.description.ability.AbilityDescriptionScreen;
import it.hurts.sskirillss.relics.client.screen.description.ability.widgets.base.AbstractAbilityActionWidget;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.leveling.PacketRelicTweak;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class RerollAbilityActionWidget
extends AbstractAbilityActionWidget {
    public RerollAbilityActionWidget(int x, int y, AbilityDescriptionScreen screen) {
        super(x, y, PacketRelicTweak.Operation.REROLL, screen);
    }

    @Override
    public boolean isLocked() {
        IRelicItem relic;
        Item item = this.getScreen().getStack().getItem();
        return !(item instanceof IRelicItem) || !(relic = (IRelicItem)item).mayPlayerReroll((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
    }

    @Override
    public void playDownSound(SoundManager handler) {
        IRelicItem relic;
        Item item;
        if (this.isLocked() || !((item = this.getScreen().getStack().getItem()) instanceof IRelicItem) || (relic = (IRelicItem)item).getAbilityQuality(this.getScreen().getStack(), this.getAbility()) == relic.getMaxQuality() && !Screen.hasShiftDown()) {
            return;
        }
        handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundRegistry.TABLE_REROLL.get()), (float)1.0f));
    }

    @Override
    public void onPress() {
        boolean hasWarning;
        Item item;
        if (this.isLocked() || !((item = this.getScreen().getStack().getItem()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        boolean bl = hasWarning = relic.getAbilityQuality(this.getScreen().getStack(), this.getAbility()) == relic.getMaxQuality();
        if (hasWarning && !Screen.hasShiftDown()) {
            return;
        }
        NetworkHandler.sendToServer(new PacketRelicTweak(this.getScreen().getContainer(), this.getScreen().getSlot(), this.getAbility(), PacketRelicTweak.Operation.REROLL, !hasWarning && Screen.hasShiftDown()));
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        Item item = this.getScreen().getStack().getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        boolean isWarning = relic.getAbilityQuality(this.getScreen().getStack(), this.getAbility()) == relic.getMaxQuality();
        boolean isQuick = Screen.hasShiftDown() && relic.mayPlayerReroll((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility());
        float color = isWarning && Screen.hasShiftDown() || isQuick ? (float)((double)1.05f + Math.sin((float)(this.minecraft.player.tickCount + this.getAbility().length() * 10) * 0.5f) * (double)0.1f) : 1.0f;
        RenderSystem.setShaderColor((float)color, (float)color, (float)color, (float)1.0f);
        guiGraphics.blit(ResourceLocation.fromNamespaceAndPath((String)"relics", (String)("textures/gui/description/ability/reroll_button" + (String)(this.isLocked() ? "_inactive" : "_active" + (isWarning ? "_warning" : (isQuick ? "_quick" : ""))) + ".png")), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isHovered) {
            guiGraphics.blit(DescriptionTextures.ACTION_BUTTON_OUTLINE, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        }
    }

    @Override
    public void onHovered(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        IRelicItem relic;
        Item item = this.getScreen().getStack().getItem();
        if (!(item instanceof IRelicItem) || !(relic = (IRelicItem)item).isAbilityUnlocked(this.getScreen().getStack(), this.getAbility())) {
            return;
        }
        AbilityData data = relic.getAbilityData(this.getAbility());
        if (data.getStats().isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        ArrayList tooltip = Lists.newArrayList();
        int maxWidth = 120;
        int renderWidth = 0;
        int requiredExperience = relic.getRerollPlayerExperienceCost(this.getScreen().getStack(), this.getAbility());
        long experience = EntityUtils.getPlayerTotalExperience((Player)this.minecraft.player);
        MutableComponent negativeStatus = Component.translatable((String)"tooltip.relics.relic.status.negative");
        MutableComponent positiveStatus = Component.translatable((String)"tooltip.relics.relic.status.positive");
        MutableComponent unknownStatus = Component.translatable((String)"tooltip.relics.relic.status.unknown");
        boolean isQuick = relic.mayPlayerReroll((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility()) && relic.getAbilityQuality(this.getScreen().getStack(), this.getAbility()) != relic.getMaxQuality();
        boolean hasExperience = (long)requiredExperience <= experience;
        Object[] objectArray = new MutableComponent[3];
        objectArray[0] = Component.translatable((String)"tooltip.relics.relic.reroll.description").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.UNDERLINE);
        objectArray[1] = Component.literal((String)" ");
        Object[] objectArray2 = new Object[3];
        Object object = objectArray2[0] = isQuick && Screen.hasShiftDown() ? Component.literal((String)"XXX").withStyle(ChatFormatting.OBFUSCATED) : Integer.valueOf(requiredExperience);
        Object object2 = isQuick && Screen.hasShiftDown() ? Component.literal((String)"XXX").withStyle(ChatFormatting.OBFUSCATED) : (objectArray2[1] = Double.valueOf(hasExperience ? EntityUtils.calculateExperienceLevelLoss((Player)this.minecraft.player, requiredExperience) : EntityUtils.getLevelFromTotalExperience(requiredExperience)));
        objectArray2[2] = hasExperience ? (isQuick && Screen.hasShiftDown() ? unknownStatus : positiveStatus) : negativeStatus;
        objectArray[2] = Component.translatable((String)"tooltip.relics.relic.reroll.cost", (Object[])objectArray2);
        ArrayList entries = Lists.newArrayList((Object[])objectArray);
        if (relic.getAbilityQuality(this.getScreen().getStack(), this.getAbility()) == relic.getMaxQuality()) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.reroll.warning")));
        } else if (relic.mayPlayerReroll((Player)this.minecraft.player, this.getScreen().getStack(), this.getAbility())) {
            entries.add(Component.literal((String)" "));
            entries.add(Component.literal((String)"\u25b6 ").append((Component)Component.translatable((String)"tooltip.relics.relic.reroll.quick")));
        }
        for (MutableComponent entry : entries) {
            int entryWidth = (this.minecraft.font.width((FormattedText)entry) + 4) / 2;
            if (entryWidth > renderWidth) {
                renderWidth = Math.min(entryWidth, maxWidth);
            }
            tooltip.addAll(this.minecraft.font.split((FormattedText)entry, maxWidth * 2));
        }
        int height = Math.round((float)tooltip.size() * 5.0f);
        int renderX = this.getX() + this.width + 1;
        int renderY = mouseY - height / 2 - 9;
        DescriptionUtils.drawTooltipBackground(guiGraphics, renderWidth, height, renderX, renderY);
        int yOff = 0;
        poseStack.scale(0.5f, 0.5f, 0.5f);
        for (FormattedCharSequence entry : tooltip) {
            guiGraphics.drawString(this.minecraft.font, entry, (renderX + 10) * 2, (renderY + 9 + yOff) * 2, 6696723, false);
            yOff += 5;
        }
        poseStack.scale(1.0f, 1.0f, 1.0f);
    }
}

