/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.ceremonies.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.ModConfigSpec;

public class InfusingConfig {
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> INFUSE_MAPPINGS;

    public static Map<Block, Block> getInfuseMap() {
        HashMap<Block, Block> map = new HashMap<Block, Block>();
        for (String entry : (List)INFUSE_MAPPINGS.get()) {
            String[] parts = entry.split("->");
            if (parts.length != 2) continue;
            String fromStr = parts[0].trim();
            String toStr = parts[1].trim();
            Block from = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)fromStr));
            Block to = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)toStr));
            if (from == null || to == null || from == Blocks.AIR || to == Blocks.AIR) continue;
            map.put(from, to);
        }
        return map;
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Totemic Infusion Ceremony");
        INFUSE_MAPPINGS = builder.comment(new String[]{"List of infusion mappings in the format: from -> to", "Example: minecraft:gravel -> minecraft:diamond_block"}).defineList("infuseMappings", Arrays.asList("minecraft:mud -> minecraft:clay"), obj -> obj instanceof String);
        builder.pop();
        SPEC = builder.build();
    }
}

