/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.ceremonies.ceremony;

import com.benbenlaw.ceremonies.config.InfusingConfig;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.ceremony.CeremonyEffectContext;
import pokefenn.totemic.api.ceremony.CeremonyInstance;
import pokefenn.totemic.util.MiscUtil;

public enum TotemicInfusionCeremony implements CeremonyInstance
{
    INSTANCE;

    private static final int RADIUS = 8;

    public void effect(Level level, BlockPos pos, CeremonyEffectContext context) {
        if (!level.isClientSide && context.getTime() % 20 == 0) {
            TotemicInfusionCeremony.infuseBlocks(level, pos);
        }
    }

    private static void infuseBlocks(Level level, BlockPos pos) {
        Map<Block, Block> infuseMap = InfusingConfig.getInfuseMap();
        BlockPos.betweenClosedStream((BoundingBox)TotemicEntityUtil.getBoundingBoxAround((BlockPos)pos, (int)8)).forEach(p -> {
            BlockState state = level.getBlockState(p);
            Block from = state.getBlock();
            if (infuseMap.containsKey(from)) {
                Block to = (Block)infuseMap.get(from);
                level.setBlock(p, to.defaultBlockState(), 3);
                MiscUtil.spawnServerParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (Level)level, (Vec3)Vec3.atCenterOf((Vec3i)p), (int)10, (Vec3)new Vec3(0.5, 0.5, 0.5), (double)0.0);
            }
        });
    }

    public int getEffectTime() {
        return 1200;
    }

    public boolean canSelect(Level level, BlockPos pos, Entity initiator) {
        return true;
    }
}

