/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.screen;

import com.benbenlaw.shops.capability.PlayerBalanceData;
import com.benbenlaw.shops.capability.ShopsAttachments;
import com.benbenlaw.shops.loaders.ShopEntry;
import com.benbenlaw.shops.loaders.ShopRegistry;
import com.benbenlaw.shops.network.packets.SyncAutoItemToServer;
import com.benbenlaw.shops.network.packets.SyncPurchaseToServer;
import com.benbenlaw.shops.screen.ShopMenu;
import com.benbenlaw.shops.screen.TooltipArea;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.network.PacketDistributor;

public class ShopScreen
extends AbstractContainerScreen<ShopMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"textures/gui/shop_gui.png");
    private final int columns = 6;
    private final int startX = 28;
    private final int startY = 34;
    private final int spacingX = 18;
    private final int spacingY = 18;
    private final int maxVisibleRows = 2;
    private int scrollOffset = 0;
    private Button scrollUpButton;
    private Button scrollDownButton;
    public ItemStack autoProduced;
    private EditBox searchBox;
    private String lastSearch = "";

    public ShopScreen(ShopMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.autoProduced = ((ShopMenu)this.menu).blockEntity.getAutoProduced();
        this.searchBox = new EditBox(this.font, this.leftPos + 34, this.topPos + 17, 108, 12, (Component)Component.literal((String)"Search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(0xFFFFFF);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        int buttonX = this.leftPos + 137;
        int scrollUpY = this.topPos + 36;
        int scrollDownY = this.topPos + 55;
        this.scrollUpButton = Button.builder((Component)Component.literal((String)"\u25b2"), button -> {
            if (this.scrollOffset > 0) {
                --this.scrollOffset;
            }
        }).bounds(buttonX, scrollUpY, 12, 12).build();
        this.scrollDownButton = Button.builder((Component)Component.literal((String)"\u25bc"), button -> {
            List<ShopEntry> items = this.getFilteredItems();
            int totalRows = (int)Math.ceil((double)items.size() / 6.0);
            if (this.scrollOffset < totalRows - 2) {
                ++this.scrollOffset;
            }
        }).bounds(buttonX, scrollDownY, 12, 12).build();
        this.addRenderableWidget((GuiEventListener)this.scrollUpButton);
        this.addRenderableWidget((GuiEventListener)this.scrollDownButton);
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        for (DisplayedItem di : this.getVisibleItems()) {
            graphics.renderItem(di.entry().getItem(), di.x(), di.y());
            graphics.renderItemDecorations(this.font, di.entry().getItem(), di.x(), di.y());
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean canScroll;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        this.searchBox.render(graphics, mouseX, mouseY, partialTicks);
        for (DisplayedItem di : this.getVisibleItems()) {
            if (!ShopScreen.isMouseOver(mouseX, mouseY, di.x(), di.y(), 16, 16)) continue;
            List fullTooltip = di.entry.getItem().getTooltipLines(Item.TooltipContext.EMPTY, ((ShopMenu)this.menu).player, (TooltipFlag)TooltipFlag.NORMAL);
            fullTooltip.add(Component.literal((String)("Price: " + di.entry().getPrice() + " coins")).withStyle(ChatFormatting.GOLD));
            graphics.renderTooltip(this.font, fullTooltip, Optional.empty(), mouseX, mouseY);
        }
        int totalRows = (int)Math.ceil((double)this.getFilteredItems().size() / 6.0);
        this.scrollUpButton.visible = canScroll = totalRows > 2;
        this.scrollDownButton.visible = canScroll;
        this.renderAutoProducedItem(graphics, mouseX, mouseY);
        this.renderSlotTooltips(graphics, mouseX, mouseY, this.leftPos, this.topPos);
    }

    private void renderSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        List<TooltipArea> tooltipAreas = List.of(new TooltipArea(8, 16, 16, 16, "block.shops.shop.player_balance_card"), new TooltipArea(8, 34, 16, 16, "block.shops.shop.selling_input"), new TooltipArea(8, 52, 16, 16, "block.shops.shop.catalog"), new TooltipArea(152, 52, 16, 16, "block.shops.shop.output"));
        for (TooltipArea area : tooltipAreas) {
            if (!ShopScreen.isMouseAboveArea(mouseX, mouseY, x, y, area.offsetX, area.offsetY, area.width, area.height) || !((ShopMenu)this.menu).getCarried().isEmpty() || this.hoveredSlot == null || this.hoveredSlot.hasItem()) continue;
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)area.translationKey), mouseX, mouseY);
        }
        if (this.autoProduced.isEmpty() && ShopScreen.isMouseAboveArea(mouseX, mouseY, x, y, 152, 34, 16, 16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.shops.shop.auto_produce"), mouseX, mouseY);
        }
    }

    private void renderAutoProducedItem(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.autoProduced.isEmpty()) {
            int x = this.leftPos + 152;
            int y = this.topPos + 34;
            graphics.renderItem(this.autoProduced, x, y);
            if (ShopScreen.isMouseOver(mouseX, mouseY, x, y, 16, 16)) {
                graphics.renderTooltip(this.font, (Component)Component.literal((String)("Auto Produce: " + this.autoProduced.getHoverName().getString())), mouseX, mouseY);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.searchBox != null && this.searchBox.isMouseOver(mouseX, mouseY) && button == 1) {
            this.searchBox.setValue("");
            this.searchBox.setFocused(true);
            this.lastSearch = "";
            this.scrollOffset = 0;
            return true;
        }
        for (DisplayedItem di : this.getVisibleItems()) {
            if (ShopScreen.isMouseOver(mouseX, mouseY, di.x(), di.y(), 16, 16)) {
                ShopEntry item = di.entry();
                if (button == 0) {
                    PlayerBalanceData balance = (PlayerBalanceData)((ShopMenu)this.menu).player.getData(ShopsAttachments.PLAYER_BALANCE);
                    if (balance == null) {
                        return super.mouseClicked(mouseX, mouseY, button);
                    }
                    if (balance.getBalance() >= item.getPrice()) {
                        int newBalance = balance.getBalance() - item.getPrice();
                        balance.setBalance(newBalance);
                        ((ShopMenu)this.menu).player.getInventory().add(item.getItem().copy());
                        PacketDistributor.sendToServer((CustomPacketPayload)new SyncPurchaseToServer(newBalance, item.getItem().copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        ((ShopMenu)this.menu).player.sendSystemMessage((Component)Component.literal((String)"Not enough balance!"));
                    }
                } else if (button == 1) {
                    this.autoProduced = this.autoProduced != null && ItemStack.isSameItem((ItemStack)this.autoProduced, (ItemStack)item.getItem()) ? ItemStack.EMPTY : item.getItem().copy();
                    PacketDistributor.sendToServer((CustomPacketPayload)new SyncAutoItemToServer(((ShopMenu)this.menu).blockPos, this.autoProduced.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return true;
            }
            if (!ShopScreen.isMouseOver(mouseX, mouseY, this.leftPos + 152, this.topPos + 34, 16, 16) || this.autoProduced.isEmpty() || button != 0 && button != 1) continue;
            this.autoProduced = ItemStack.EMPTY;
            PacketDistributor.sendToServer((CustomPacketPayload)new SyncAutoItemToServer(((ShopMenu)this.menu).blockPos, this.autoProduced.copy()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        List<ShopEntry> items = this.getFilteredItems();
        int totalRows = (int)Math.ceil((double)items.size() / 6.0);
        if (totalRows <= 2) {
            return false;
        }
        this.scrollOffset = (int)((double)this.scrollOffset - deltaY);
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, totalRows - 2));
        return true;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.searchBox != null && this.searchBox.isFocused()) {
            assert (this.minecraft != null);
            if (this.minecraft.options.keyInventory.matches(key, scanCode)) {
                return true;
            }
            if (this.searchBox.keyPressed(key, scanCode, modifiers)) {
                return true;
            }
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public List<ShopEntry> getFilteredItems() {
        ItemStack catalogueStack = ((ShopMenu)this.menu).blockEntity.getItemStackHandler().getStackInSlot(2);
        List<Object> baseItems = !catalogueStack.isEmpty() ? ShopRegistry.getByCatalog(catalogueStack) : List.of();
        baseItems = baseItems.stream().filter(entry -> entry.getMode() == ShopEntry.ShopMode.PLAYER_BUYS).toList();
        if (this.searchBox != null && !this.searchBox.getValue().isEmpty()) {
            String query = this.searchBox.getValue().toLowerCase(Locale.ROOT);
            if (!query.equals(this.lastSearch)) {
                this.scrollOffset = 0;
                this.lastSearch = query;
            }
            baseItems = baseItems.stream().filter(entry -> entry.getItem().getHoverName().getString().toLowerCase(Locale.ROOT).contains(query)).toList();
        } else {
            this.lastSearch = "";
        }
        return baseItems;
    }

    private List<DisplayedItem> getVisibleItems() {
        ArrayList<DisplayedItem> visible = new ArrayList<DisplayedItem>();
        List<ShopEntry> items = this.getFilteredItems();
        for (int i = 0; i < items.size(); ++i) {
            int col = i % 6;
            int row = i / 6;
            if (row < this.scrollOffset || row >= this.scrollOffset + 2) continue;
            int x = this.leftPos + 28 + col * 18;
            int y = this.topPos + 34 + (row - this.scrollOffset) * 18;
            visible.add(new DisplayedItem(items.get(i), x, y));
        }
        return visible;
    }

    public static boolean isMouseOver(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX >= (double)x && mouseX <= (double)(x + width) && mouseY >= (double)y && mouseY <= (double)(y + height);
    }

    public static boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return ShopScreen.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, width, height);
    }

    public record DisplayedItem(ShopEntry entry, int x, int y) {
    }
}

