/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.renderer;

import com.benbenlaw.shops.entity.CrateEntity;
import com.benbenlaw.shops.renderer.CrateModel;
import com.benbenlaw.shops.renderer.CrateModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CrateRenderer
extends EntityRenderer<CrateEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"shops", (String)"textures/entity/crate/crate.png");
    private final CrateModel model;

    public CrateRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new CrateModel(ctx.bakeLayer(CrateModelLayers.CRATE));
        this.shadowRadius = 0.25f;
    }

    public void render(CrateEntity crate, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.0);
        this.model.render(poseStack, buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((Entity)crate, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(CrateEntity crate) {
        return TEXTURE;
    }
}

