/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.benbenlaw.shops.loaders.ShopEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ShopRegistry {
    public static final List<ShopEntry> SHOP_ENTRIES = new ArrayList<ShopEntry>();
    private static boolean synced = false;

    public static void clear() {
        SHOP_ENTRIES.clear();
    }

    public static void register(ShopEntry entry) {
        SHOP_ENTRIES.add(entry);
    }

    public static List<ShopEntry> getAllEntries() {
        return Collections.unmodifiableList(SHOP_ENTRIES);
    }

    public static List<ShopEntry> getByMode(ShopEntry.ShopMode mode) {
        ArrayList<ShopEntry> filtered = new ArrayList<ShopEntry>();
        for (ShopEntry entry : SHOP_ENTRIES) {
            if (entry.getMode() != mode) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public static List<ShopEntry> getByCatalog(ItemStack catalogItem) {
        ArrayList<ShopEntry> filtered = new ArrayList<ShopEntry>();
        for (ShopEntry entry : SHOP_ENTRIES) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)entry.getRequiredCatalogItem(), (ItemStack)catalogItem)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    public static ShopEntry getByItem(Item item) {
        for (ShopEntry entry : SHOP_ENTRIES) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)entry.getItem(), (ItemStack)new ItemStack((ItemLike)item))) continue;
            return entry;
        }
        return null;
    }

    public static int getPrice(ItemStack stack, ShopEntry.ShopMode mode) {
        for (ShopEntry entry : SHOP_ENTRIES) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)entry.getItem(), (ItemStack)stack) || entry.getMode() != mode) continue;
            return entry.getPrice();
        }
        return -1;
    }

    public static boolean isSynced() {
        return synced;
    }

    public static void setSynced(boolean value) {
        synced = value;
    }
}

