/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ShopEntry {
    private final ItemStack item;
    private final int price;
    private final ShopMode mode;
    private final ItemStack requiredCatalog;
    public static final Codec<ShopMode> MODE_CODEC = Codec.STRING.xmap(s -> ShopMode.valueOf(s.toUpperCase(Locale.ROOT)), Enum::name);
    public static final Codec<ShopEntry> CODEC = RecordCodecBuilder.create(shopEntryInstance -> shopEntryInstance.group((App)ItemStack.CODEC.fieldOf("stack").forGetter(ShopEntry::getItem), (App)Codec.INT.fieldOf("price").forGetter(ShopEntry::getPrice), (App)MODE_CODEC.fieldOf("mode").forGetter(ShopEntry::getMode)).apply((Applicative)shopEntryInstance, (item, price, mode) -> new ShopEntry((ItemStack)item, (int)price, (ShopMode)((Object)((Object)mode)), ItemStack.EMPTY)));
    public static final StreamCodec<RegistryFriendlyByteBuf, ShopEntry> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ShopEntry::getItem, (StreamCodec)ByteBufCodecs.INT, ShopEntry::getPrice, (StreamCodec)ByteBufCodecs.STRING_UTF8, entry -> entry.getMode().name(), (StreamCodec)ItemStack.STREAM_CODEC, ShopEntry::getRequiredCatalogItem, (item, price, modeString, catalog) -> new ShopEntry((ItemStack)item, (int)price, ShopMode.valueOf(modeString.toUpperCase()), (ItemStack)catalog));

    public ShopEntry(ItemStack item, int price, ShopMode mode, ItemStack requiredCatalogue) {
        this.item = item;
        this.price = price;
        this.mode = mode;
        this.requiredCatalog = requiredCatalogue;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getPrice() {
        return this.price;
    }

    public ShopMode getMode() {
        return this.mode;
    }

    public ItemStack getRequiredCatalogItem() {
        return this.requiredCatalog;
    }

    public static enum ShopMode {
        PLAYER_BUYS,
        PLAYER_SELLS;

    }
}

