/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.benbenlaw.shops.loaders.PinataData;
import com.benbenlaw.shops.network.packets.SyncPinatasToClients;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.network.PacketDistributor;

public class PinataLoader
extends SimpleJsonResourceReloadListener {
    public static final Map<ResourceLocation, PinataData> PINATAS = new HashMap<ResourceLocation, PinataData>();

    public PinataLoader(Gson gson, String directory) {
        super(gson, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        PINATAS.clear();
        jsonMap.forEach((id, json) -> {
            DataResult result = PinataData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            result.resultOrPartial(message -> System.err.println("Error loading pinata " + String.valueOf(id) + ": " + message)).ifPresent(pinataData -> PINATAS.put((ResourceLocation)id, (PinataData)pinataData));
        });
    }

    public static PinataData getPinata(ResourceLocation id) {
        return PINATAS.get(id);
    }

    public static Map<ResourceLocation, PinataData> getAllPinatas() {
        return Collections.unmodifiableMap(PINATAS);
    }

    public static void sendLoaderInformation(ServerPlayer player) {
        ArrayList<PinataData> allEntries = new ArrayList<PinataData>();
        ArrayList<ResourceLocation> allIds = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, PinataData> entry : PINATAS.entrySet()) {
            allIds.add(entry.getKey());
            allEntries.add(entry.getValue());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPinatasToClients(allIds, allEntries), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void clear() {
        PINATAS.clear();
    }

    public static void register(ResourceLocation id, PinataData pinataData) {
        PINATAS.put(id, pinataData);
    }
}

