/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record PinataData(int mainColor, ResourceLocation lootTable, ResourceLocation model) {
    public static final Codec<Integer> COLOR_CODEC = Codec.STRING.xmap(PinataData::parseColor, color -> String.format("#%08X", color));
    public static final Codec<PinataData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)COLOR_CODEC.fieldOf("main_color").forGetter(PinataData::mainColor), (App)ResourceLocation.CODEC.fieldOf("loot_table").forGetter(PinataData::lootTable), (App)ResourceLocation.CODEC.fieldOf("model").forGetter(PinataData::model)).apply((Applicative)inst, PinataData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PinataData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PinataData::mainColor, (StreamCodec)ResourceLocation.STREAM_CODEC, PinataData::lootTable, (StreamCodec)ResourceLocation.STREAM_CODEC, PinataData::model, PinataData::new);

    public static int parseColor(String colorStr) {
        if (colorStr.startsWith("#")) {
            return (int)Long.parseLong(colorStr.substring(1), 16);
        }
        return Integer.parseInt(colorStr);
    }
}

