/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.loaders;

import com.benbenlaw.shops.loaders.CrateData;
import com.benbenlaw.shops.network.packets.SyncCratesToClients;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.network.PacketDistributor;

public class CrateLoader
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, CrateData> CRATES = new HashMap<ResourceLocation, CrateData>();

    public CrateLoader(Gson gson, String directory) {
        super(gson, directory);
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonMap, ResourceManager resourceManager, ProfilerFiller profiler) {
        CRATES.clear();
        jsonMap.forEach((id, json) -> {
            DataResult result = CrateData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
            result.resultOrPartial(message -> System.err.println("Error loading pinata " + String.valueOf(id) + ": " + message)).ifPresent(pinataData -> CRATES.put((ResourceLocation)id, (CrateData)pinataData));
        });
    }

    public static CrateData getCrate(ResourceLocation id) {
        return CRATES.get(id);
    }

    public static Map<ResourceLocation, CrateData> getAllCrates() {
        return Collections.unmodifiableMap(CRATES);
    }

    public static void sendLoaderInformation(ServerPlayer player) {
        ArrayList<CrateData> allEntries = new ArrayList<CrateData>();
        ArrayList<ResourceLocation> allIds = new ArrayList<ResourceLocation>();
        for (Map.Entry<ResourceLocation, CrateData> entry : CRATES.entrySet()) {
            allIds.add(entry.getKey());
            allEntries.add(entry.getValue());
        }
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncCratesToClients(allIds, allEntries), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void clear() {
        CRATES.clear();
    }

    public static void register(ResourceLocation id, CrateData crateData) {
        CRATES.put(id, crateData);
    }
}

