/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.item;

import com.benbenlaw.shops.item.ShopsDataComponents;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PlayerBalanceCard
extends Item {
    public PlayerBalanceCard(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() instanceof PlayerBalanceCard) {
            stack.set((DataComponentType)ShopsDataComponents.PLAYER_UUID.get(), (Object)player.getStringUUID());
            stack.set((DataComponentType)ShopsDataComponents.PLAYER_USERNAME.get(), (Object)String.valueOf(player.getGameProfile().getName()));
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag flag) {
        if (Screen.hasShiftDown()) {
            if (stack.has((DataComponentType)ShopsDataComponents.PLAYER_UUID.get())) {
                String playerName = stack.has((DataComponentType)ShopsDataComponents.PLAYER_USERNAME.get()) ? Objects.requireNonNull((String)stack.get((DataComponentType)ShopsDataComponents.PLAYER_USERNAME.get())) : "Error";
                list.add((Component)Component.translatable((String)"tooltip.shops.bound_to", (Object[])new Object[]{playerName}).withStyle(ChatFormatting.BLUE));
            } else {
                list.add((Component)Component.translatable((String)"tooltip.shops.how_to").withStyle(ChatFormatting.BLUE));
            }
        } else {
            list.add((Component)Component.translatable((String)"tooltip.shops.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

