/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.item;

import com.benbenlaw.shops.entity.PinataEntity;
import com.benbenlaw.shops.entity.ShopsEntities;
import com.benbenlaw.shops.item.ShopsDataComponents;
import com.benbenlaw.shops.item.ShopsItems;
import com.benbenlaw.shops.loaders.PinataData;
import com.benbenlaw.shops.loaders.PinataLoader;
import com.benbenlaw.shops.util.TickScheduler;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PinataFlareItem
extends Item {
    public PinataFlareItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Vec3 exactPos = context.getClickLocation();
        Vec3 hitVec = exactPos.subtract(Vec3.atLowerCornerOf((Vec3i)pos));
        Direction direction = context.getClickedFace();
        Level level = context.getLevel();
        PinataEntity pinata = new PinataEntity(ShopsEntities.PINATA.get(), level);
        ResourceLocation pinataType = (ResourceLocation)context.getItemInHand().get(ShopsDataComponents.PINATA_ID);
        PinataData data = PinataLoader.getPinata(pinataType);
        int color = data.mainColor();
        if (direction == Direction.UP) {
            this.createFirework(level, color, exactPos);
            if (!context.getPlayer().isCreative()) {
                context.getItemInHand().shrink(1);
            }
            TickScheduler.schedule(level, 60, () -> {
                Vec3 spawnPos = exactPos.add(0.0, 50.0, 0.0);
                Vec3 playerPos = context.getPlayer().position().add(0.0, (double)context.getPlayer().getEyeHeight(), 0.0);
                Vec3 lookVec = playerPos.subtract(spawnPos);
                float yaw = (float)(Math.atan2(lookVec.z, lookVec.x) * 57.29577951308232) - 90.0f;
                pinata.absMoveTo(spawnPos.x, spawnPos.y, spawnPos.z, yaw, 0.0f);
                pinata.yBodyRot = yaw;
                pinata.yHeadRot = yaw;
                pinata.yBodyRot = yaw;
                assert (pinataType != null);
                pinata.setPinataType(pinataType);
                level.addFreshEntity((Entity)pinata);
                level.playSound(null, pos, SoundEvents.FIREWORK_ROCKET_LAUNCH, pinata.getSoundSource(), 1.0f, 1.0f);
            });
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        ResourceLocation pinataType = (ResourceLocation)stack.get(ShopsDataComponents.PINATA_ID);
        assert (pinataType != null);
        String path = pinataType.getPath();
        components.add((Component)Component.translatable((String)("item.shops.pinata_flare." + path)));
    }

    public void createFirework(Level level, int color, Vec3 position) {
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.LARGE_BALL, IntList.of((int)color), IntList.of((int)color), true, true);
        Fireworks fireworks = new Fireworks(3, List.of(explosion));
        ItemStack rocket = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        rocket.set(DataComponents.FIREWORKS, (Object)fireworks);
        FireworkRocketEntity entity = new FireworkRocketEntity(level, position.x, position.y, position.z, rocket);
        level.addFreshEntity((Entity)entity);
    }

    public static ItemStack createPinataFlare(ResourceLocation path) {
        ItemStack stack = new ItemStack((ItemLike)ShopsItems.PINATA_FLARE.get());
        stack.set(ShopsDataComponents.PINATA_ID, (Object)path);
        return stack;
    }
}

