/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.command;

import com.benbenlaw.shops.capability.PlayerBalanceData;
import com.benbenlaw.shops.capability.ShopsAttachments;
import com.benbenlaw.shops.network.packets.SyncPlayerBalanceToClient;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class BalanceCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"player_balance").then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BalanceCommand.addBalance((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BalanceCommand.removeBalance((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(4))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BalanceCommand.setBalance((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"))))))).then(Commands.literal((String)"transfer").then(Commands.argument((String)"to_player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> BalanceCommand.transferBalance((CommandContext<CommandSourceStack>)ctx, EntityArgument.getPlayer((CommandContext)ctx, (String)"to_player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount")))))));
    }

    private static int addBalance(CommandContext<CommandSourceStack> ctx, ServerPlayer player, int amount) {
        ((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).addBalance(amount);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Added " + amount + " to " + player.getName().getString())), true);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPlayerBalanceToClient(((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int removeBalance(CommandContext<CommandSourceStack> ctx, ServerPlayer player, int amount) {
        ((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).subtractBalance(amount);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Removed " + amount + " from " + player.getName().getString())), true);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPlayerBalanceToClient(((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int setBalance(CommandContext<CommandSourceStack> ctx, ServerPlayer player, int amount) {
        ((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).setBalance(amount);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Set " + player.getName().getString() + "'s balance to " + amount)), true);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SyncPlayerBalanceToClient(((PlayerBalanceData)player.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int transferBalance(CommandContext<CommandSourceStack> ctx, ServerPlayer toPlayer, int amount) {
        ServerPlayer fromPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        assert (fromPlayer != null);
        if (((PlayerBalanceData)fromPlayer.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance() < amount) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)(fromPlayer.getName().getString() + " does not have enough balance to transfer " + amount)));
            return 0;
        }
        ((PlayerBalanceData)fromPlayer.getData(ShopsAttachments.PLAYER_BALANCE.get())).subtractBalance(amount);
        ((PlayerBalanceData)toPlayer.getData(ShopsAttachments.PLAYER_BALANCE.get())).addBalance(amount);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("Transferred " + amount + " from " + fromPlayer.getName().getString() + " to " + toPlayer.getName().getString())), true);
        PacketDistributor.sendToPlayer((ServerPlayer)fromPlayer, (CustomPacketPayload)new SyncPlayerBalanceToClient(((PlayerBalanceData)fromPlayer.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        PacketDistributor.sendToPlayer((ServerPlayer)toPlayer, (CustomPacketPayload)new SyncPlayerBalanceToClient(((PlayerBalanceData)toPlayer.getData(ShopsAttachments.PLAYER_BALANCE.get())).getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }
}

