/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.shops.block.entity;

import com.benbenlaw.shops.block.entity.ShopsBlockEntities;
import com.benbenlaw.shops.capability.PlayerBalanceData;
import com.benbenlaw.shops.capability.ShopsAttachments;
import com.benbenlaw.shops.item.ShopsDataComponents;
import com.benbenlaw.shops.item.ShopsItems;
import com.benbenlaw.shops.loaders.ShopEntry;
import com.benbenlaw.shops.loaders.ShopRegistry;
import com.benbenlaw.shops.network.packets.SyncPlayerBalanceToClient;
import com.benbenlaw.shops.screen.ShopMenu;
import com.benbenlaw.shops.util.InputOutputItemHandler;
import com.benbenlaw.shops.util.ShopsTags;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShopBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ContainerData data;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            ShopBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0 && stack.is(ShopsItems.PLAYER_BALANCE_CARD)) {
                return true;
            }
            if (slot == 1 && !stack.is(ShopsTags.Items.CATALOGS)) {
                return true;
            }
            if (slot == 2 && stack.is(ShopsTags.Items.CATALOGS)) {
                return true;
            }
            if (slot == 3) {
                return false;
            }
            return false;
        }
    };
    public static final int PLAYER_BALANCE_CARD = 0;
    public static final int INPUT_SLOT = 1;
    public static final int CATALOG = 2;
    public static final int OUTPUT_SLOT = 3;
    private ItemStack autoProduced = ItemStack.EMPTY;
    private final IItemHandler shopItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (slot, stack) -> slot == 1, slot -> slot == 3);

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public IItemHandler getShopItemHandler(Direction side) {
        return this.shopItemHandler;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.shops.shop");
    }

    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ShopMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public ShopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ShopsBlockEntities.SHOP_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(this){

            public int get(int index) {
                return 0;
            }

            public void set(int index, int value) {
            }

            public int getCount() {
                return 0;
            }
        };
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ItemStack input = this.itemHandler.getStackInSlot(1);
        ItemStack balanceCard = this.itemHandler.getStackInSlot(0);
        if (balanceCard.has(ShopsDataComponents.PLAYER_UUID)) {
            ShopEntry buyEntry;
            ItemStack requiredCatalogue;
            ShopEntry sellEntry;
            Player cardPlayer = this.level.getPlayerByUUID(UUID.fromString(Objects.requireNonNull((String)balanceCard.get(ShopsDataComponents.PLAYER_UUID))));
            if (!(cardPlayer instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)cardPlayer;
            PlayerBalanceData balanceData = (PlayerBalanceData)cardPlayer.getData(ShopsAttachments.PLAYER_BALANCE);
            if (!input.isEmpty() && (sellEntry = (ShopEntry)ShopRegistry.getAllEntries().stream().filter(e -> e.getMode() == ShopEntry.ShopMode.PLAYER_SELLS).filter(e -> ItemStack.isSameItemSameComponents((ItemStack)e.getItem(), (ItemStack)input)).findFirst().orElse(null)) != null) {
                requiredCatalogue = sellEntry.getRequiredCatalogItem();
                int requiredAmount = sellEntry.getItem().getCount();
                int price = sellEntry.getPrice();
                if (input.getCount() >= requiredAmount && (requiredCatalogue.isEmpty() || this.playerHasCatalogueItem(requiredCatalogue))) {
                    this.itemHandler.extractItem(1, requiredAmount, false);
                    balanceData.addBalance(price);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerBalanceToClient(balanceData.getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.setChanged();
                }
            }
            if (!this.autoProduced.isEmpty() && (buyEntry = (ShopEntry)ShopRegistry.getAllEntries().stream().filter(e -> e.getMode() == ShopEntry.ShopMode.PLAYER_BUYS).filter(e -> ItemStack.isSameItemSameComponents((ItemStack)e.getItem(), (ItemStack)this.autoProduced)).findFirst().orElse(null)) != null) {
                requiredCatalogue = buyEntry.getRequiredCatalogItem();
                int price = buyEntry.getPrice();
                ItemStack toOutput = this.autoProduced.copy();
                if (balanceData.getBalance() >= price && (requiredCatalogue.isEmpty() || this.playerHasCatalogueItem(requiredCatalogue)) && this.canOutput(toOutput)) {
                    balanceData.setBalance(balanceData.getBalance() - price);
                    this.addToOutputSlot(toOutput);
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerBalanceToClient(balanceData.getBalance()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.setChanged();
                }
            }
        }
    }

    private boolean playerHasCatalogueItem(ItemStack catalogueItem) {
        return ItemStack.isSameItemSameComponents((ItemStack)this.itemHandler.getStackInSlot(2), (ItemStack)catalogueItem);
    }

    private boolean canOutput(ItemStack stackToAdd) {
        ItemStack currentStack = this.itemHandler.getStackInSlot(3);
        if (currentStack.isEmpty()) {
            return true;
        }
        if (ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)stackToAdd)) {
            int combined = currentStack.getCount() + stackToAdd.getCount();
            return combined <= currentStack.getMaxStackSize();
        }
        return false;
    }

    private void addToOutputSlot(ItemStack stackToAdd) {
        ItemStack currentStack = this.itemHandler.getStackInSlot(3);
        if (currentStack.isEmpty()) {
            int count = Math.min(stackToAdd.getCount(), stackToAdd.getMaxStackSize());
            ItemStack newStack = stackToAdd.copy();
            newStack.setCount(count);
            this.itemHandler.setStackInSlot(3, newStack);
        } else if (ItemStack.isSameItemSameComponents((ItemStack)currentStack, (ItemStack)stackToAdd)) {
            int combined = currentStack.getCount() + stackToAdd.getCount();
            int max = currentStack.getMaxStackSize();
            currentStack.setCount(Math.min(combined, max));
            this.itemHandler.setStackInSlot(3, currentStack);
        }
    }

    public void setAutoProduced(ItemStack stack) {
        this.autoProduced = stack.copy();
        this.setChanged();
    }

    public ItemStack getAutoProduced() {
        return this.autoProduced;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        if (!this.autoProduced.isEmpty()) {
            compoundTag.put("autoProduced", this.autoProduced.save(provider));
        }
    }

    protected void loadAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.autoProduced = compoundTag.contains("autoProduced") ? ItemStack.parse((HolderLookup.Provider)provider, (Tag)compoundTag.getCompound("autoProduced")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveWithoutMetadata(p_323910_);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

