/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.client;

import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.client.hat.HatLayer;
import fonnymunkey.simplehats.client.hatdisplay.HatDisplayModel;
import fonnymunkey.simplehats.client.hatdisplay.HatDisplayRenderer;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="simplehats", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent
    public static void registerItemColor(RegisterColorHandlersEvent.Item event) {
        for (Item item : SimpleHatsCommon.MOD_REGISTRY.getHatList()) {
            if (item instanceof HatItemDyeable) {
                HatItemDyeable hatDye = (HatItemDyeable)item;
                event.register((stack, color) -> ((HatItemDyeable)stack.getItem()).getColor(stack), new ItemLike[]{hatDye});
            }
            if (!(item instanceof AccessoryRenderer)) continue;
            AccessoriesRendererRegistry.registerNoRenderer((Item)item);
        }
        AccessoriesRendererRegistry.registerNoRenderer((Item)SimpleHatsCommon.MOD_REGISTRY.getHatSpecial());
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity(), HatDisplayRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HatDisplayRenderer.HATDISPLAY_LOCATION, HatDisplayModel::getTexturedModelData);
    }

    @SubscribeEvent
    public static void addEntityLayers(EntityRenderersEvent.AddLayers event) {
        PlayerRenderer playerRenderer;
        EntityRenderer entityRenderer = event.getSkin(PlayerSkin.Model.WIDE);
        if (entityRenderer instanceof PlayerRenderer) {
            playerRenderer = (PlayerRenderer)entityRenderer;
            playerRenderer.addLayer(new HatLayer(playerRenderer));
        }
        if ((entityRenderer = event.getSkin(PlayerSkin.Model.SLIM)) instanceof PlayerRenderer) {
            playerRenderer = (PlayerRenderer)entityRenderer;
            playerRenderer.addLayer(new HatLayer(playerRenderer));
        }
    }
}

