/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.util.trade;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TradeOfferInternals {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-villager-api-v1");

    private TradeOfferInternals() {
    }

    public static synchronized void registerVillagerOffers(VillagerProfession profession, int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        Objects.requireNonNull(profession, "VillagerProfession may not be null.");
        TradeOfferInternals.registerOffers((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.TRADES.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, factory);
    }

    public static synchronized void registerWanderingTraderOffers(int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        TradeOfferInternals.registerOffers((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.WANDERING_TRADER_TRADES, level, factory);
    }

    private static void registerOffers(Int2ObjectMap<VillagerTrades.ItemListing[]> leveledTradeMap, int level, Consumer<List<VillagerTrades.ItemListing>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (VillagerTrades.ItemListing[])leveledTradeMap.computeIfAbsent(level, key -> new VillagerTrades.ItemListing[0]);
        Object[] addedEntries = list.toArray(new VillagerTrades.ItemListing[0]);
        VillagerTrades.ItemListing[] allEntries = (VillagerTrades.ItemListing[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }

    public static void printRefreshOffersWarning() {
        Throwable loggingThrowable = new Throwable();
        LOGGER.warn("TradeOfferHelper#refreshOffers does not do anything, yet it was called! Stack trace:", loggingThrowable);
    }
}

