/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.screen.gui;

import com.iafenvoy.iceandfire.data.BestiaryPage;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.screen.handler.LecternScreenHandler;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class LecternScreen
extends AbstractContainerScreen<LecternScreenHandler> {
    private static final ResourceLocation ENCHANTMENT_TABLE_GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/gui/lectern.png");
    private static final ResourceLocation ENCHANTMENT_TABLE_BOOK_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/lectern_book.png");
    private static BookModel bookModel;
    private final Random random = new Random();
    private final Component nameable;
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;
    private int flapTimer = 0;

    public LecternScreen(LecternScreenHandler container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.nameable = name;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    protected void renderLabels(GuiGraphics ms, int mouseX, int mouseY) {
        assert (this.minecraft != null);
        Font font = this.minecraft.font;
        font.drawInBatch(this.nameable.getString(), 12.0f, 4.0f, 0x404040, false, ms.pose().last().pose(), (MultiBufferSource)ms.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(this.playerInventoryTitle, 8.0f, (float)(this.imageHeight - 96 + 2), 0x404040, false, ms.pose().last().pose(), (MultiBufferSource)ms.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void containerTick() {
        super.containerTick();
        ((LecternScreenHandler)this.menu).onUpdate();
        this.tickBook();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        assert (this.minecraft != null);
        assert (this.minecraft.gameMode != null);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        for (int k = 0; k < 3; ++k) {
            double l = mouseX - (double)(i + 60);
            double i1 = mouseY - (double)(j + 14 + 19 * k);
            if (!(l >= 0.0) || !(i1 >= 0.0) || !(l < 108.0) || !(i1 < 19.0) || !((LecternScreenHandler)this.menu).clickMenuButton((Player)this.minecraft.player, k)) continue;
            this.flapTimer = 5;
            this.minecraft.gameMode.handleInventoryButtonClick(((LecternScreenHandler)this.menu).containerId, k);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        assert (this.minecraft != null);
        Lighting.setupForFlatItems();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)this.minecraft.getWindow().getGuiScale();
        RenderSystem.viewport((int)((this.width - 320) / 2 * k), (int)((this.height - 240) / 2 * k), (int)(320 * k), (int)(240 * k));
        Matrix4f matrix4f = new Matrix4f().m03(-0.34f).m13(0.23f);
        matrix4f.mul((Matrix4fc)new Matrix4f().perspective(90.0f, 1.3333334f, 9.0f, 80.0f));
        ms.pose().pushPose();
        ms.pose().setIdentity();
        ms.pose().translate(0.0, (double)3.3f, 1984.0);
        ms.pose().scale(5.0f, 5.0f, 5.0f);
        ms.pose().mulPose(Axis.ZP.rotationDegrees(180.0f));
        ms.pose().mulPose(Axis.XP.rotationDegrees(20.0f));
        float f1 = Mth.lerp((float)partialTicks, (float)this.oOpen, (float)this.open);
        ms.pose().translate((1.0f - f1) * 0.2f, (1.0f - f1) * 0.1f, (1.0f - f1) * 0.25f);
        float f2 = -(1.0f - f1) * 90.0f - 90.0f;
        ms.pose().mulPose(Axis.YP.rotationDegrees(f2));
        ms.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float f3 = Mth.lerp((float)partialTicks, (float)this.oFlip, (float)this.flip) + 0.25f;
        float f4 = Mth.lerp((float)partialTicks, (float)this.oFlip, (float)this.flip) + 0.75f;
        f3 = (f3 - (float)Mth.floor((float)f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)Mth.floor((float)f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        bookModel.setupAnim(0.0f, f3, f4, f1);
        VertexConsumer vertexconsumer = ms.bufferSource().getBuffer(bookModel.renderType(ENCHANTMENT_TABLE_BOOK_TEXTURE));
        bookModel.renderToBuffer(ms.pose(), vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
        ms.flush();
        ms.pose().popPose();
        RenderSystem.viewport((int)0, (int)0, (int)this.minecraft.getWindow().getWidth(), (int)this.minecraft.getWindow().getHeight());
        Lighting.setupFor3DItems();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i1 = 0; i1 < 3; ++i1) {
            int j1 = i + 60;
            int k1 = j1 + 20;
            int l1 = ((LecternScreenHandler)this.menu).getPossiblePages()[i1] == null ? -1 : IafRegistries.BESTIARY_PAGE.getId((Object)((LecternScreenHandler)this.menu).getPossiblePages()[i1]);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (l1 == -1) {
                ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
                continue;
            }
            String s = "3";
            Font fontrenderer = this.minecraft.font;
            String s1 = "";
            float textScale = 1.0f;
            BestiaryPage enchantment = ((LecternScreenHandler)this.menu).getPossiblePages()[i1];
            if (enchantment != null && fontrenderer.width(s1 = I18n.get((String)("bestiary." + enchantment.name()), (Object[])new Object[0])) > 80) {
                textScale = 1.0f - (float)(fontrenderer.width(s1) - 80) * 0.01f;
            }
            int j2 = 6839882;
            if (((LecternScreenHandler)this.menu).getSlot(0).getItem().getItem() == IafItems.BESTIARY.get()) {
                int k2 = mouseX - (i + 60);
                int l2 = mouseY - (j + 14 + 19 * i1);
                int j3 = 10459276;
                if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                    ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 204, 108, 19);
                    j2 = 0xFFFF80;
                    j3 = 0xFFFF80;
                } else {
                    ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 166, 108, 19);
                }
                ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1 + 1, j + 15 + 19 * i1, 16 * i1, 223, 16, 16);
                ms.pose().pushPose();
                ms.pose().translate((float)this.width / 2.0f - 10.0f, (float)this.height / 2.0f - 83.0f + (1.0f - textScale) * 55.0f, 2.0f);
                ms.pose().scale(textScale, textScale, 1.0f);
                fontrenderer.drawInBatch(s1, 0.0f, (float)(20 + 19 * i1), j2, false, ms.pose().last().pose(), (MultiBufferSource)ms.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                ms.pose().popPose();
                fontrenderer = this.minecraft.font;
                fontrenderer.drawInBatch(s, (float)(k1 + 84 - fontrenderer.width(s)), (float)(j + 13 + 19 * i1 + 7), j3, true, ms.pose().last().pose(), (MultiBufferSource)ms.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                continue;
            }
            ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
            ms.blit(ENCHANTMENT_TABLE_GUI_TEXTURE, j1 + 1, j + 15 + 19 * i1, 16 * i1, 239, 16, 16);
        }
    }

    public void render(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(ms, mouseX, mouseY, partialTicks);
        super.render(ms, mouseX, mouseY, partialTicks);
        this.renderTooltip(ms, mouseX, mouseY);
    }

    public void tickBook() {
        ItemStack itemstack = ((LecternScreenHandler)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches((ItemStack)itemstack, (ItemStack)this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.ticks;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            if (((LecternScreenHandler)this.menu).getPossiblePages()[i] == null) continue;
            flag = true;
        }
        this.open += flag ? 0.2f : -0.2f;
        this.open = Mth.clamp((float)this.open, (float)0.0f, (float)1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        if (this.flapTimer > 0) {
            assert (this.minecraft != null);
            f1 = ((float)this.ticks + this.minecraft.getTimer().getGameTimeDeltaPartialTick(false)) * 0.5f;
            --this.flapTimer;
        }
        f1 = Mth.clamp((float)f1, (float)-0.2f, (float)0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

