/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.IceAndFire;
import com.iafenvoy.iceandfire.entity.HydraEntity;
import com.iafenvoy.iceandfire.entity.StoneStatueEntity;
import com.iafenvoy.iceandfire.entity.TrollEntity;
import com.iafenvoy.iceandfire.registry.IafRenderLayers;
import com.iafenvoy.iceandfire.render.entity.feature.HydraHeadFeatureRenderer;
import com.iafenvoy.iceandfire.render.model.HydraBodyModel;
import com.iafenvoy.iceandfire.render.model.ICustomStatueModel;
import com.iafenvoy.iceandfire.render.model.StonePlayerModel;
import com.iafenvoy.uranus.client.model.AdvancedEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class StoneStatueEntityRenderer
extends EntityRenderer<StoneStatueEntity> {
    protected static final ResourceLocation[] DESTROY_STAGES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"textures/block/destroy_stage_0.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_1.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_2.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_3.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_4.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_5.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_6.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_7.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_8.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/destroy_stage_9.png")};
    private final Map<String, EntityModel> modelMap = new HashMap<String, EntityModel>();
    private final Map<String, Entity> hollowEntityMap = new HashMap<String, Entity>();
    private final EntityRendererProvider.Context context;

    public StoneStatueEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.context = context;
    }

    public ResourceLocation getTexture(StoneStatueEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    protected void preRenderCallback(StoneStatueEntity entity, PoseStack matrixStackIn, float partialTickTime) {
        float scale = entity.getAgeScale() < 0.01f ? 1.0f : entity.getAgeScale();
        matrixStackIn.scale(scale, scale, scale);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(StoneStatueEntity entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float yaw;
        Entity fakeEntity;
        void var7_12;
        block21: {
            VertexConsumer ivertexbuilder;
            block20: {
                block19: {
                    block18: {
                        PigModel pigModel = new PigModel(this.context.bakeLayer(ModelLayers.PIG));
                        if (this.modelMap.get(entityIn.getTrappedEntityTypeString()) != null) {
                            EntityModel entityModel = this.modelMap.get(entityIn.getTrappedEntityTypeString());
                        } else {
                            void var7_11;
                            EntityRenderer renderer = (EntityRenderer)Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(entityIn.getTrappedEntityType());
                            if (renderer instanceof RenderLayerParent) {
                                EntityModel entityModel = ((RenderLayerParent)renderer).getModel();
                            } else if (entityIn.getTrappedEntityType() == EntityType.PLAYER) {
                                StonePlayerModel stonePlayerModel = new StonePlayerModel(this.context.bakeLayer(ModelLayers.PLAYER));
                            }
                            this.modelMap.put(entityIn.getTrappedEntityTypeString(), (EntityModel)var7_11);
                        }
                        if (var7_12 == null) {
                            return;
                        }
                        if (this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString()) != null) break block18;
                        fakeEntity = entityIn.getTrappedEntityType().create((Level)Minecraft.getInstance().level);
                        if (fakeEntity != null) {
                            try {
                                fakeEntity.load(entityIn.getTrappedTag());
                            }
                            catch (Exception e) {
                                IceAndFire.LOGGER.warn("Mob {} could not build statue NBT", (Object)entityIn.getTrappedEntityTypeString());
                            }
                            this.hollowEntityMap.putIfAbsent(entityIn.getTrappedEntityTypeString(), fakeEntity);
                        }
                        break block19;
                    }
                    fakeEntity = this.hollowEntityMap.get(entityIn.getTrappedEntityTypeString());
                }
                RenderType tex = IafRenderLayers.getStoneMobRenderType(200.0f, 200.0f);
                if (fakeEntity instanceof TrollEntity) {
                    TrollEntity troll = (TrollEntity)fakeEntity;
                    tex = RenderType.entityCutout((ResourceLocation)troll.getTrollType().getStatueTexture());
                }
                ivertexbuilder = bufferIn.getBuffer(tex);
                matrixStackIn.pushPose();
                yaw = entityIn.yRotO + (entityIn.getYRot() - entityIn.yRotO) * partialTicks;
                var7_12.young = entityIn.isBaby();
                var7_12.riding = false;
                var7_12.attackTime = entityIn.getAttackAnim(partialTicks);
                if (var7_12 instanceof AdvancedEntityModel) {
                    AdvancedEntityModel advancedEntityModel = (AdvancedEntityModel)var7_12;
                    advancedEntityModel.resetToDefaultPose();
                } else if (fakeEntity != null) {
                    var7_12.setupAnim(fakeEntity, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f);
                }
                this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
                matrixStackIn.translate(0.0f, 1.5f, 0.0f);
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(yaw));
                if (!(var7_12 instanceof ICustomStatueModel)) break block20;
                ICustomStatueModel statueModel = (ICustomStatueModel)var7_12;
                if (fakeEntity == null) break block20;
                statueModel.renderStatue(matrixStackIn, ivertexbuilder, packedLightIn, fakeEntity);
                if (var7_12 instanceof HydraBodyModel) {
                    HydraBodyModel hydraBody = (HydraBodyModel)var7_12;
                    if (fakeEntity instanceof HydraEntity) {
                        HydraEntity hydra = (HydraEntity)fakeEntity;
                        HydraHeadFeatureRenderer.renderHydraHeads(hydraBody, true, matrixStackIn, bufferIn, packedLightIn, hydra, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, 0.0f);
                    }
                }
                break block21;
            }
            var7_12.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
        }
        matrixStackIn.popPose();
        if (entityIn.getCrackAmount() >= 1) {
            int i = Mth.clamp((int)(entityIn.getCrackAmount() - 1), (int)0, (int)(DESTROY_STAGES.length - 1));
            RenderType crackTex = IafRenderLayers.getStoneCrackRenderType(DESTROY_STAGES[i]);
            VertexConsumer ivertexbuilder2 = bufferIn.getBuffer(crackTex);
            matrixStackIn.pushPose();
            matrixStackIn.pushPose();
            this.preRenderCallback(entityIn, matrixStackIn, partialTicks);
            matrixStackIn.translate(0.0f, 1.5f, 0.0f);
            matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
            matrixStackIn.mulPose(Axis.YP.rotationDegrees(yaw));
            if (var7_12 instanceof ICustomStatueModel) {
                ICustomStatueModel statueModel = (ICustomStatueModel)var7_12;
                statueModel.renderStatue(matrixStackIn, ivertexbuilder2, packedLightIn, fakeEntity);
            } else {
                var7_12.renderToBuffer(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            }
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }
}

