/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.block;

import com.iafenvoy.iceandfire.item.block.LecternBlock;
import com.iafenvoy.iceandfire.item.block.entity.LecternBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;

public class LecternBlockEntityRenderer<T extends LecternBlockEntity>
implements BlockEntityRenderer<T> {
    private static final RenderType ENCHANTMENT_TABLE_BOOK_TEXTURE = RenderType.entityCutoutNoCull((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iceandfire", (String)"textures/entity/lectern_book.png"));
    private final BookModel bookModel;

    public LecternBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.bookModel = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public void render(T entity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.5f, 1.1f, 0.5f);
        matrixStackIn.scale(0.8f, 0.8f, 0.8f);
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(this.getRotation((LecternBlockEntity)((Object)entity))));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(112.0f));
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(90.0f));
        float f4 = ((LecternBlockEntity)((Object)entity)).pageFlipPrev + (((LecternBlockEntity)((Object)entity)).pageFlip - ((LecternBlockEntity)((Object)entity)).pageFlipPrev) * partialTicks + 0.25f;
        float f5 = ((LecternBlockEntity)((Object)entity)).pageFlipPrev + (((LecternBlockEntity)((Object)entity)).pageFlip - ((LecternBlockEntity)((Object)entity)).pageFlipPrev) * partialTicks + 0.75f;
        f4 = (f4 - (float)Mth.floor((float)f4)) * 1.6f - 0.3f;
        f5 = (f5 - (float)Mth.floor((float)f5)) * 1.6f - 0.3f;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f5 < 0.0f) {
            f5 = 0.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        if (f5 > 1.0f) {
            f5 = 1.0f;
        }
        float f6 = 1.29f;
        this.bookModel.setupAnim(partialTicks, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
        this.bookModel.renderToBuffer(matrixStackIn, bufferIn.getBuffer(ENCHANTMENT_TABLE_BOOK_TEXTURE), combinedLightIn, combinedOverlayIn, -1);
        matrixStackIn.popPose();
    }

    private float getRotation(LecternBlockEntity lectern) {
        return switch ((Direction)lectern.getBlockState().getValue((Property)LecternBlock.FACING)) {
            case Direction.EAST -> 90.0f;
            case Direction.WEST -> -90.0f;
            case Direction.SOUTH -> 0.0f;
            default -> 180.0f;
        };
    }
}

