/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.particle;

import com.iafenvoy.iceandfire.particle.DragonFrostParticleType;
import com.iafenvoy.uranus.object.VecUtil;
import com.iafenvoy.uranus.util.RandomHelper;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DragonFrostParticle
extends TextureSheetParticle {
    protected DragonFrostParticle(DragonFrostParticleType parameters, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteProvider) {
        super(world, x, y, z);
        float size = parameters.getScale();
        this.quadSize *= (float)RandomHelper.nextDouble((double)size, (double)(size * 2.0f));
        this.lifetime = 30;
        this.gravity = 0.0f;
        this.hasPhysics = false;
        this.pickSprite(spriteProvider);
        this.setParticleSpeed(RandomHelper.randomize((double)velocityX, (double)0.5), RandomHelper.randomize((double)velocityY, (double)0.5), RandomHelper.randomize((double)velocityZ, (double)0.5));
    }

    public static ParticleProvider<DragonFrostParticleType> factory(SpriteSet spriteProvider) {
        return (parameters, world, x, y, z, velocityX, velocityY, velocityZ) -> new DragonFrostParticle((DragonFrostParticleType)parameters, world, x, y, z, velocityX, velocityY, velocityZ, spriteProvider);
    }

    public int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if (j > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void tick() {
        super.tick();
        BlockState state = this.level.getBlockState(VecUtil.createBlockPos((double)this.x, (double)this.y, (double)this.z));
        if (state != null && state.isSolid()) {
            this.remove();
        }
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    protected record Provider(SpriteSet spriteProvider) implements ParticleProvider<DragonFrostParticleType>
    {
        public Particle createParticle(DragonFrostParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new DragonFrostParticle(typeIn, worldIn, x, y, z, velocityX, velocityY, velocityZ, this.spriteProvider);
        }
    }
}

