/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.loot;

import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.item.DragonEggItem;
import com.iafenvoy.iceandfire.item.DragonFleshItem;
import com.iafenvoy.iceandfire.item.DragonScalesItem;
import com.iafenvoy.iceandfire.item.DragonSkullItem;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafLoots;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class DragonLootFunction
extends LootItemConditionalFunction {
    public static final MapCodec<DragonLootFunction> CODEC = RecordCodecBuilder.mapCodec(instance -> DragonLootFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, DragonLootFunction::new));

    public DragonLootFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Object object;
        if (!stack.isEmpty() && (object = context.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof DragonBaseEntity) {
            DragonBaseEntity dragon = (DragonBaseEntity)object;
            if (stack.getItem() == IafItems.DRAGON_BONE.get()) {
                stack.setCount(1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 25));
                return stack;
            }
            if (stack.getItem() instanceof DragonScalesItem) {
                stack.setCount(dragon.getAgeInDays() / 25 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.getCount());
            }
            if (stack.getItem() instanceof DragonEggItem) {
                if (dragon.isMature()) {
                    return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getEggItem(), stack.getCount());
                }
                stack.setCount(1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 5));
                return new ItemStack((ItemLike)DragonColor.getById(dragon.getVariant()).getScaleItem(), stack.getCount());
            }
            if (stack.getItem() instanceof DragonFleshItem) {
                return new ItemStack((ItemLike)dragon.getFleshItem(), 1 + dragon.getRandom().nextInt(1 + dragon.getAgeInDays() / 25));
            }
            if (stack.getItem() instanceof DragonSkullItem) {
                return stack.transmuteCopy((ItemLike)dragon.getSkull(), stack.getCount());
            }
            if (stack.is(IafItemTags.DRAGON_BLOODS)) {
                return new ItemStack((ItemLike)dragon.getBloodItem(), stack.getCount());
            }
            if (stack.is(IafItemTags.DRAGON_HEARTS)) {
                return new ItemStack(dragon.getHeartItem(), stack.getCount());
            }
        }
        return stack;
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return (LootItemFunctionType)IafLoots.DRAGON_LOOT.get();
    }
}

