/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.block.entity;

import com.iafenvoy.iceandfire.data.BestiaryPage;
import com.iafenvoy.iceandfire.item.BestiaryItem;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafRegistries;
import com.iafenvoy.iceandfire.screen.handler.LecternScreenHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LecternBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsSides = new int[]{1};
    private static final int[] slotsBottom = new int[]{0};
    private static final Random RANDOM = new Random();
    private static final ArrayList<BestiaryPage> EMPTY_LIST = new ArrayList();
    private final Random localRand = new Random();
    public float pageFlip;
    public float pageFlipPrev;
    public float pageHelp1;
    public float pageHelp2;
    public final BestiaryPage[] selectedPages = new BestiaryPage[3];
    public final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            BestiaryPage page = LecternBlockEntity.this.selectedPages[index];
            return page == null ? -1 : IafRegistries.BESTIARY_PAGE.getId((Object)page);
        }

        public void set(int index, int value) {
            LecternBlockEntity.this.selectedPages[index] = (BestiaryPage)IafRegistries.BESTIARY_PAGE.byId(value);
        }

        public int getCount() {
            return 3;
        }
    };
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);

    public LecternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IafBlockEntities.IAF_LECTERN.get(), pos, state);
    }

    public static void bookAnimationTick(Level world, BlockPos pos, BlockState state, LecternBlockEntity lectern) {
        float f1 = lectern.pageHelp1;
        do {
            lectern.pageHelp1 += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
        } while (f1 == lectern.pageHelp1);
        lectern.pageFlipPrev = lectern.pageFlip;
        float f = (lectern.pageHelp1 - lectern.pageFlip) * 0.04f;
        float f3 = 0.02f;
        f = Mth.clamp((float)f, (float)(-f3), (float)f3);
        lectern.pageHelp2 += (f - lectern.pageHelp2) * 0.9f;
        lectern.pageFlip += lectern.pageHelp2;
    }

    public int getContainerSize() {
        return 2;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    private List<BestiaryPage> getPossiblePages() {
        List<BestiaryPage> list = BestiaryPage.possiblePages((ItemStack)this.stacks.getFirst());
        if (!list.isEmpty()) {
            return list;
        }
        return EMPTY_LIST;
    }

    public ItemStack removeItem(int index, int count) {
        if (!((ItemStack)this.stacks.get(index)).isEmpty()) {
            ItemStack itemstack;
            if (((ItemStack)this.stacks.get(index)).getCount() <= count) {
                itemstack = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.EMPTY);
            } else {
                itemstack = ((ItemStack)this.stacks.get(index)).split(count);
                if (((ItemStack)this.stacks.get(index)).getCount() == 0) {
                    this.stacks.set(index, (Object)ItemStack.EMPTY);
                }
            }
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setItem(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
        if (((ItemStack)this.stacks.get(0)).isEmpty() || ((ItemStack)this.stacks.get(1)).isEmpty()) {
            this.selectedPages[0] = null;
            this.selectedPages[1] = null;
            this.selectedPages[2] = null;
        } else {
            this.randomizePages(this.getItem(0), this.getItem(1));
        }
    }

    public void randomizePages(ItemStack bestiary, ItemStack manuscript) {
        assert (this.level != null);
        if (!this.level.isClientSide && bestiary.getItem() == IafItems.BESTIARY.get()) {
            List<BestiaryPage> possibleList = this.getPossiblePages();
            this.localRand.setSeed(this.level.getGameTime());
            Collections.shuffle(possibleList, this.localRand);
            this.selectedPages[0] = !possibleList.isEmpty() ? possibleList.get(0) : null;
            this.selectedPages[1] = possibleList.size() > 1 ? possibleList.get(1) : null;
            this.selectedPages[2] = possibleList.size() > 2 ? possibleList.get(2) : null;
        }
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.stacks, (HolderLookup.Provider)registryLookup);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.stacks, (HolderLookup.Provider)registryLookup);
    }

    public void startOpen(Player player) {
    }

    public void stopOpen(Player player) {
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (index == 0) {
            return stack.getItem() instanceof BestiaryItem;
        }
        if (index == 1) {
            return stack.getItem() == IafItems.MANUSCRIPT.get();
        }
        return false;
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.stacks.clear();
    }

    public Component getName() {
        return Component.translatable((String)"block.iceandfire.lectern");
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean hasCustomName() {
        return false;
    }

    public int[] getSlotsForFace(Direction side) {
        return side == Direction.DOWN ? slotsBottom : (side == Direction.UP ? slotsTop : slotsSides);
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack itemStackIn, Direction direction) {
        return this.canPlaceItem(index, itemStackIn);
    }

    public ItemStack removeItemNoUpdate(int index) {
        return ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithFullMetadata(registryLookup);
    }

    protected Component getDefaultName() {
        return this.getName();
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> inventory) {
        this.stacks = inventory;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory player) {
        return null;
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new LecternScreenHandler(id, (Container)this, playerInventory, this.propertyDelegate);
    }
}

